/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: utils.c,v 1.9 2003/10/15 19:06:45 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <string.h>

#include <liblm.h>
#include <config_msd.h>
#include "ip2country.h"

int get_user_domain(lm_string_t * puser, lm_string_t * pdomain,
                    lm_string_t addr)
{
    int index;
    lm_string_t user = NULL;
    lm_string_t domain = NULL;

    LM_STRING_DUP(user, addr);
    if (!LM_STRING_CHR(user, '@', index)) {
        LM_STRING_DUP(domain, addr);
        LM_STRING_END_SHIFT(user, LM_STRING_LEN(user) - index);
        LM_STRING_START_SHIFT(domain, index + 1);
    } else {
        /* There was no @ specified so set the domain to nothing */
        LM_STRING_NEW(domain, "");
    }

    LM_ASSERT(puser != NULL);
    LM_ASSERT(pdomain != NULL);

    *puser = user;
    *pdomain = domain;

    return (*puser == NULL) || (*pdomain == NULL);
}

int get_user(lm_string_t * puser, lm_string_t addr)
{
    int index;
    lm_string_t user = NULL;

    LM_STRING_DUP(user, addr);
    if (!LM_STRING_CHR(addr, '@', index)) {
        LM_STRING_END_SHIFT(user, LM_STRING_LEN(user) - index);
    }

    LM_ASSERT(puser);
    *puser = user;
    return *puser == NULL;
}

int get_domain(lm_string_t * pdomain, lm_string_t addr)
{
    int index;
    lm_string_t domain = NULL;

    if (!LM_STRING_CHR(addr, '@', index)) {
        LM_STRING_DUP(domain, addr);
        LM_STRING_START_SHIFT(domain, index + 1);
    } else {
        /* No @ sign, empty domain */
        LM_STRING_NEW(domain, "");
    }

    LM_ASSERT(pdomain != NULL);
    *pdomain = domain;
    return *pdomain == NULL;
}

/*
  This function attempts to find the regular expression:
   [0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}
   which would match any dotted decimal ip address
   Returns 0 on sucess, non-zero on failure 
*/
int is_ip(lm_string_t addr)
{
    int retval = 0;
    int index = 0;
    int numdots = 0;
    int len;
    char *buffer;

    buffer = LM_STRING_BUFFER(addr);
    len = LM_STRING_LEN(addr);

    while (!retval && index < len) {
        if (buffer[index] == '.') {
            numdots++;
            if (index > numdots * 3 + (numdots - 1)) {
                retval = 1;
            }
        } else {
            if (!isdigit(buffer[index])) {
                retval = 1;
            } else {
                if (index > (numdots + 1) * 3 + (numdots - 1)) {
                    retval = 1;
                }
            }
        }
        index++;
    }

    return retval;
}

int ip_to_country_code(lm_string_t * pcc, lm_string_t ip)
{
    lm_string_t cc = NULL;
    ccdata_t ccdata;
    char country[3];

    /* start w/ zero'd memory */
    bzero(country, sizeof(country));

    ccdata = initGetCC();
    if (ccdata == NULL) {
        syslog(LOG_ERR, "initGetCC() Failed\n");
        return (1);
    }

    if (getCC(ccdata, LM_STRING_BUFFER(ip), country) != 0) {
        return (1);
    }

    /* don't need this any more, so clean it up */
    destroyCC(ccdata);

    LM_STRING_NEW(cc, country);
    syslog(LOG_INFO, "IP country code[%s]", LM_STRING_BUFFER(cc));

    *pcc = cc;
    return *pcc == NULL;
}

char *splitUser(char *email)
{
    char *ptr, *out;

    out = NULL;
    ptr = strrchr(email, '@');
    if (ptr != NULL) {
        *ptr = '\0';
        out = strdup(email);
        *ptr = '@';
    } else {
        out = strdup(email);
    }

    return (out);
}

char *splitDomain(char *email)
{
    char *ptr, *out;

    out = NULL;
    ptr = strrchr(email, '@');
    if (ptr != NULL)  {
        out = strdup(ptr+1);
    }

    return (out);
}
