/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: strlist.h,v 1.6 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#include <liblm.h>

#ifndef _STRING_LIST_H
#define _STRING_LIST_H

typedef struct 
{
  int num_lines;
  int *lines;
  char *buffer;
} tag_strlist_t;

#define STRLIST_NEW(strlist, string) strlist_new(&strlist, string)
#define STRLIST_FREE(strlist) strlist_free(&strlist)
#define STRLIST_TO_STRING(string, strlist) strlist_to_string(&string, strlist)

typedef struct tag_strlist_t* strlist_t;

int strlist_new(strlist_t *pstrlist, lm_string_t string);
int strlist_free(strlist_t *pstrlist);
int strlist_to_string(lm_string_t* pstr, strlist_t strlist);

int strlist_string_cmp(lm_string_t a, lm_string_t b);
int strlist_regex_cmp(lm_string_t r, lm_string_t b);
int strlist_dotdomain_cmp(lm_string_t domain, lm_string_t wcdomain);
int strlist_atdomain_cmp(lm_string_t domain, lm_string_t wcdomain);
/*int in_strlist(lm_string_t str, lm_string_t list, int (*cmp)(lm_string_t, lm_string_t));*/
int strlist_search(strlist_t strlist, lm_string_t str, int (*cmp)(lm_string_t, lm_string_t));

#endif
