/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: smtp.h,v 1.3 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#include <liblm.h>

#ifndef _SMTP_H
#define _SMTP_H

/* Maximum line length for a message line */
#define SMTP_MAX_LINE_LENGTH 1024

#define SMTP_AUTH_TYPE_STRING_LOGIN "login"
#define SMTP_AUTH_TYPE_STRING_PLAIN "plain"
#define SMTP_AUTH_TYPE_STRING_CRAM_MD5 "cram-md5"
#define SMTP_AUTH_TYPE_STRING_DIGEST_MD5 "digest-md5"
#define SMTP_AUTH_LOGIN 0
#define SMTP_AUTH_PLAIN 1
#define SMTP_AUTH_CRAM_MD5 2
#define SMTP_AUTH_DIGEST_MD5 3

/* TODO Decide when these callbacks should be done:
   1) right after the command is done, ie. before any further processing
   2 )after default processing
   Probably 1 i'm thinking.
   */
typedef int (*smtp_helo_handler_callback_t)(lm_string_t domain);
typedef int (*smtp_ehlo_handler_callback_t)(lm_string_t domain);
typedef int (*smtp_mail_handler_callback_t)(lm_string_t addr);
typedef int (*smtp_rcpt_handler_callback_t)(lm_string_t addr);
typedef int (*smtp_data_handler_callback_t)(void);
typedef int (*smtp_auth_handler_callback_t)(int authtype, lm_string_t username64);
typedef int (*smtp_quit_handler_callback_t)(int exitcode);
typedef int (*smtp_rset_handler_callback_t)(void);
typedef int (*smtp_help_handler_callback_t)(void);
typedef int (*smtp_noop_handler_callback_t)(void);
typedef int (*smtp_vrfy_handler_callback_t)(lm_string_t addr);

typedef int (*smtp_read_callback_t)(int fd, lm_string_t* buf);
typedef int (*smtp_write_callback_t)(int fd, lm_string_t buf);

/* Calling program recieves the following callbacks in order after DATA command
   is recieved: */
/* Perform any initialization the might be required for queueing (exec child proc, etc) */
typedef int (*smtp_queue_init_callback_t)(void);

/* There are two of these callbacks specified in the init call: one for header 
   lines and one for body lines.  THey can both be the same function if the
   calling program doesn't need to know the distinction */
/* This callback can default to storing the message to disk, in memory or 
   passing it through pipes and saving it for itself.  THe smpt system does
   not store the data at all */ 
typedef int (*smtp_data_line_callback_t)(lm_string_t line); 

/* Perform the acutal queue operation with the given from and rcpt list  */
typedef int (*smtp_queue_callback_t)(void);

/* Perform any cleanup after queueing that might be required */
typedef int (*smtp_queue_cleanup_callback_t)(void);


/* Call to init smtp subsystem.  If you don't want a callback on the paticular command then
   just pass a null as the parameter */
/* The callback functions are called after the arguments have been processed by the smtp system, 
   but before any smpt data is modified internally.  If you want to keep the smtp system from
   performing it's default processing with the given argument data, have the provided callback
   function to return non-zero, else return zero and the smtp system will be have normally */
/* TODO Clean this up and have a set function for each callback, or a set function which
   takes a constant to say which function to set */
int smtp_init(int smpt_timeout, 
		smtp_read_callback_t pread_func,
		smtp_write_callback_t pwrite_func,
		smtp_queue_init_callback_t pqueue_init_func,
		smtp_queue_callback_t pqueue_func,
		smtp_queue_cleanup_callback_t pqueue_cleanup_func,
		smtp_helo_handler_callback_t phelo_func,
		smtp_ehlo_handler_callback_t pehlo_func,
		smtp_mail_handler_callback_t pmail_func,
		smtp_rcpt_handler_callback_t prcpt_func,
		smtp_data_handler_callback_t pdata_func,
		smtp_auth_handler_callback_t pauth_func,
		smtp_vrfy_handler_callback_t pvrfy_func,
		smtp_rset_handler_callback_t prset_func,
		smtp_help_handler_callback_t phelp_func,
		smtp_noop_handler_callback_t pnoop_func,
		smtp_quit_handler_callback_t pquit_func,
		smtp_data_line_callback_t pheader_line_func,
		smtp_data_line_callback_t pbody_line_func);

int smtp_cleanup(void);
int smtp_read_command(lm_string_t* command);
int smtp_handle_command(lm_string_t command);
int smtp_match_domain(lm_string_t domain, lm_string_t wcdomain);

#endif /* _SMTP_H */
