/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: lmstring.h,v 1.21 2003/09/19 18:56:04 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#include <liblm_config.h>

#ifndef _LMSTRING_H
#define _LMSTRING_H

/************************************/
/* BEGIN PUBLIC FUNCTIONS AND TYPES */
/************************************/

typedef struct tag_lm_string_t* lm_string_t;

#define LM_STRING_NEW(str,string) _LM_STRING_NEW(str,string)
#define LM_STRING_FREE(str) _lm_string_free(&str)

#define LM_STRING_LEN(str) _lm_string_len(str)
#define LM_STRING_BUFFER(str) _lm_string_buffer(str)

/* Duplicate the string fromstr and assign the new string to tostr */
#define LM_STRING_DUP(tostr, fromstr) _LM_STRING_DUP(tostr, fromstr)

/* Appent fromstr to the end of tostr, reallocating as needed */
#define LM_STRING_CAT(tostr, fromstr) _LM_STRING_CAT(tostr, fromstr)

/* Compare two strings, man strncmp and strncasecmp for returns */
#define LM_STRING_CMP(str1,str2) _lm_string_cmp(str1,str2)
#define LM_STRING_CASECMP(str1,str2) _lm_string_casecmp(str1,str2)

/* Reads a line from file upto max bytes. Bytesread is true if something was read, or false 
   if an error or end of file occured during the read operation */
#define LM_STRING_FGETS(str, file, max, bytesread) _LM_STRING_FGETS(str,file,max,bytesread)

/* Chop whitespace (\r\n\t and spaces) from the end of the given string */
#define LM_STRING_CHOP(str) _lm_string_chop(str)

/* Chop whitespace (\r\n\t and spaces) from the start of the given string */
#define LM_STRING_CHOP_HEAD(str) _lm_string_chop_head(str)

/* Find the location of the  first instance of the given character in the string */
/* Puts the index of the character in index, returns 0 if the character is found
   else returns -1 */
#define LM_STRING_CHR(str, chr, index) _lm_string_chr(str,chr,&index)

/* Find the location of the last instance of the given character in the string */
/* Puts the index of the character in index, returns 0 if the character is found
   else returns -1 */
#define LM_STRING_RCHR(str, chr, index) _lm_string_rchr(str,chr,&index)

/* Shift the start of the string forward by amount characters */
#define LM_STRING_START_SHIFT(str, amount) _lm_string_start_shift(str, amount)

/* Shift the start of the string backward by amount characters */
#define LM_STRING_END_SHIFT(str, amount) _lm_string_end_shift(str, amount)

/* Convert a string to an intger using sscanf */
#define LM_STRING_TO_INT(str,retval) _lm_string_to_int(str,&retval)

/* Strip a line from the given string off the front of the string and return
 * it in a newly allocated string.  A line is any number of characters up to 
 * a newline.  The returned string is those characters with the newline stripped
 * off, and the original string has the line and newline shifted off the start */
#define LM_STRING_GET_LINE(string, line) _lm_string_get_line(string, &line)

/* Convert all of the characters in a string to lower/upper case */
#define LM_STRING_LOWER(str) _lm_string_lower(str)
#define LM_STRING_UPPER(str) _lm_string_upper(str)

/* Replace all the instances of the character 'from' to 'to' in the string str */
#define LM_STRING_REPLACE(str, from, to) _lm_string_replace(str,from,to)

/* Check the integrity of the string. Returns 0 if string is ok, non-zero
if not.  This should be used during run time and the return value should
be checked for failure, after which error handling can be performed.
This function is called by LM_STRING_ASSERT, but since LM_STRING_ASSERT is
not included in release builds, this function has been added to provide
for run time checking in release code. */
#define LM_STRING_CHECK(str) _LM_STRING_CHECK(str)

/* assert() type function which checks the integrity of the string
during debug builds.  These checks are compiled out in release builds,
so any checks that are required during run time release should also  be
added to maintain code integrity. */
#define LM_STRING_ASSERT(str) _lm_string_assert(str, __FILE__, __LINE__)

/**********************************/
/* END PUBLIC FUNCTIONS AND TYPES */
/**********************************/

/* See below for _lm_string_new, dup and cat definitions */
int _lm_string_free(lm_string_t* str);
int _lm_string_dup(lm_string_t* tostr, lm_string_t fromstr);
int _lm_string_len(lm_string_t str);
char* _lm_string_buffer(lm_string_t str);
int _lm_string_cmp(lm_string_t str1, lm_string_t str2);
int _lm_string_casecmp(lm_string_t str1, lm_string_t str2);
int _lm_string_cat(lm_string_t* tostr, lm_string_t fromstr);
int _lm_string_to_int(lm_string_t str, int *value);
int _lm_string_chop(lm_string_t str);
int _lm_string_chop_head(lm_string_t str);
int _lm_string_chr(lm_string_t str, char chr, int *index);
int _lm_string_rchr(lm_string_t str, char chr, int *index);
int _lm_string_start_shift(lm_string_t str, int amount);
int _lm_string_end_shift(lm_string_t str, int amount);
int _lm_string_get_line(lm_string_t str, lm_string_t* line);
int _lm_string_lower(lm_string_t str);
int _lm_string_upper(lm_string_t str);
int _lm_string_replace(lm_string_t str, char from, char to);

#if defined(_LMDEBUG)

#define _LM_STRING_NEW(str, string) _lm_string_new_debug(__FILE__, __LINE__, #str, &str, string)
#define _LM_STRING_DUP(tostr, fromstr) _lm_string_dup_debug(__FILE__, __LINE__, #tostr, &tostr, fromstr)
#define _LM_STRING_CAT(tostr, fromstr) _lm_string_cat_debug(__FILE__, __LINE__, #tostr, &tostr, fromstr)
#define _LM_STRING_FGETS(tostr, infile, maxbytes, bytesread) _lm_string_fgets_debug(__FILE__, __LINE__, #tostr, &tostr, infile, maxbytes, &bytesread)
#define _LM_STRING_CHECK(str) _lm_string_check_debug(__FILE__, __LINE__, str)

int _lm_string_new_debug(char *file, int line, char* sym, lm_string_t* pstr, char *string);
int _lm_string_dup_debug(char *file, int line, char* sym, lm_string_t* ptostr, lm_string_t fromstr);
int _lm_string_cat_debug(char *file, int line, char* sym, lm_string_t* ptostr, lm_string_t fromstr);
int _lm_string_fgets_debug(char *file, int line, char* sym, lm_string_t* str, FILE* infile, int maxbytes, size_t *bytesread);
int _lm_string_check_debug(char *file, int line, lm_string_t str);
void _lm_string_assert(lm_string_t str, char *file, int line);

#else  /* defined(_LMDEBUG) */

#define _LM_STRING_NEW(str,string) _lm_string_new(&str,string)
#define _LM_STRING_DUP(tostr, fromstr) _lm_string_dup(&tostr,fromstr)
#define _LM_STRING_CAT(tostr, fromstr) _lm_string_cat(&tostr,fromstr)
#define _LM_STRING_FGETS(tostr, infile, maxbytes, bytesread) _lm_string_fgets(&tostr, infile, maxbytes, &bytesread)
#define _LM_STRING_CHECK(str) _lm_string_check(str)
int _lm_string_new(lm_string_t* pstr, char *string);
int _lm_string_dup(lm_string_t* ptostr, lm_string_t fromstr);
int _lm_string_cat(lm_string_t* ptostr, lm_string_t fromstr);
int _lm_string_fgets(lm_string_t* str, FILE* infile, int maxbytes, size_t *bytesread);
int _lm_string_check(lm_string_t str);
#define _lm_string_assert(str,file,line) 
     
#endif  /* defined(_LMDEBUG) */


#endif /* _LMSTRING_H */
