/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: lmlogger.h,v 1.8 2003/09/19 18:56:04 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/* liblm includes */
#include <liblm_config.h>

/* Use syslog and lmlogger for main smtpd logging */
#define USE_SYSLOG 
#ifdef USE_SYSLOG
#include <syslog.h>
#define SYSLOG(msg) syslog msg
#define OPENLOG(sys, subsys) openlog(sys, LOG_PID, subsys)
#define SETLOGMASK(level) setlogmask(LOG_UPTO(level))
#define CLOSELOG closelog()

#else
#define SYSLOG(msg)
#define OPENLOG
#define CLOSELOG
#endif


/****************************
 * NO LONGER USED!!!!!!
 ****************************
 */
#if 0

#ifndef _LMLOGGER_H
#define _LMLOGGER_H

/************************************/
/* BEGIN PUBLIC FUNCTIONS AND TYPES */
/************************************/

#define LM_LOG_APP "app"

/* Console log level. No matter what the level, all messages are logged to file */
#define LM_LOG_LEVEL_NONE	0
#define LM_LOG_LEVEL_ERROR	1
#define LM_LOG_LEVEL_WARN	2
#define LM_LOG_LEVEL_MSG	3
#define LM_LOG_LEVEL_ALL	4 /* Same as LOG_LEVEL_MSG  */

/* Initialize the logger giving the name of the log file to use for
   all messages  */
#define LM_LOG_INIT(flog) _lm_log_init(argv[0], stderr, flog)

/* Set the level of messages printed to the console.  All message are 
   put in the log file */
#define LM_LOG_SET_LEVEL(level) _lm_log_set_level(level)

/* No formatted strings yet...need to sprintf those first and then pass to these */
#define LM_LOG_MSG(sys,msg) _lm_log_msg(__FILE__,__LINE__,sys,msg) 
#define LM_LOG_WARN(sys,msg) _lm_log_warn(__FILE__,__LINE__,sys,msg) 
#define LM_LOG_ERROR(sys,msg) _lm_log_error(__FILE__,__LINE__,sys,msg)

/* Reset the log file to empty */
#define LM_LOG_RESET _lm_log_reset()

/**********************************/
/* END PUBLIC FUNCTIONS AND TYPES */
/**********************************/

#if defined(LM_USE_LOGGER)

int _lm_log_init(char *app, FILE* defconsole, char* flog);
void _lm_log_set_level(int level);
void _lm_log_msg(char *file, int line, char* sys, char* format, ...);
void _lm_log_warn(char *file, int line, char* sys, char *format, ...);
void _lm_log_error(char *file, int line, char* sys, char *format, ...);
void _lm_log_reset(void);

#else /* defined LM_USE_LOGGER */

/* These do nothing when lmlogger is not enabled */
#define _lm_log_init(ferr,flog)
#define _lm_log_set_level(level)

/* By default print all logging messages to stderr */
/* FIXME Needs testing */
#define _lm_log_msg(sys, fmsg) printf("*%s*", sys); printf fmsg
#define _lm_log_warn(sys, fmsg) printf("*%s*", sys); printf fmsg
#define _lm_log_error(sys, fmsg) printf("*%s*", sys); printf fmsg

#endif /* defined LM_USE_LOGGER */

#endif /* _LM_LOGGER_H */

#endif
