/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: lmlogger.c,v 1.10 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/****************************
 * NO LONGER USED!!!!!!
 ****************************
 */
#if 0

/* C includes */
#include <stdlib.h>
#include <stdio.h>
#include <sys/param.h>
#include <stdarg.h>

/* liblm includes */
#include <liblm.h>

#if defined(LM_USE_LOGGER)

static int log_level;
static FILE *console;
static FILE *log_fmsg;
static FILE *log_fwarn;
static FILE *log_ferr;
static FILE *logfile;
static char *logfilename;
static char *appname;

int _lm_log_init(char *app, FILE * defconsole, char *flog)
{
    /* Setup module globals */
    appname = app;
    console = defconsole;
    logfilename = flog;

    /* Assume LM_LOG_LEVEL_ALL */
    LM_LOG_SET_LEVEL(LM_LOG_LEVEL_ALL);

    /* Open the log file */
    if (logfile != NULL)
        fclose(logfile);

    /* Open the log file if one was given */
    logfile = console;
    if (logfilename[0]) {
        logfile = fopen(flog, "wa");
        if (logfile == NULL) {
            char buffer[PATH_MAX + 128];

            logfile = console;
            snprintf(buffer, sizeof(buffer),
                     "Could not open log file \"%s\" for writing. Defaulting to console\n",
                     flog);
            LM_LOG_WARN("lmlogger", buffer);
        }
    }

    return 0;
}

void _lm_log_set_level(int level)
{
    LM_WARN(level < 0);
    LM_WARN(level > LM_LOG_LEVEL_ALL);
    log_level = level;

    /* Set all output levels to null */
    log_fmsg = log_fwarn = log_ferr = NULL;

    /* Update the output file handles for log levels based on new level */
    switch (log_level) {
        case LM_LOG_LEVEL_ALL:
        case LM_LOG_LEVEL_MSG:
            log_fmsg = console;
            /* Fall through  */
        case LM_LOG_LEVEL_WARN:
            log_fwarn = console;
            /* Fall through  */
        case LM_LOG_LEVEL_ERROR:
            log_ferr = console;
            break;
        case LM_LOG_LEVEL_NONE:
            break;
        default:
            LM_ASSERT(!"Should never get here: Unknown log level");
    }

    return;
}

static void __lm_log(FILE * fout, char *file, int line, char *sys, char *msg,
                     char *format, va_list * pargs)
{
    char *logformat = "%s:%s:%d\t%s";

    LM_WARN(logfile == NULL);

    if (fout) {
        /* Write to the specified file */
        fprintf(fout, logformat, sys, file, line, msg);
        vfprintf(fout, format, *pargs);
        fputc('\n', fout);

        /* Write to the default log file */
        fprintf(logfile, logformat, sys, file, line, msg);
        vfprintf(logfile, format, *pargs);
        fputc('\n', logfile);
    }
}

void _lm_log_msg(char *file, int line, char *sys, char *format, ...)
{
    va_list args;

    va_start(args, format);
    __lm_log(log_fmsg, file, line, sys, "*\t", format, &args);
    va_end(args);
}

void _lm_log_warn(char *file, int line, char *sys, char *format, ...)
{
    va_list args;

    va_start(args, format);
    __lm_log(log_fwarn, file, line, sys, "**\t", format, &args);
    va_end(args);
}

void _lm_log_error(char *file, int line, char *sys, char *format, ...)
{
    va_list args;

    va_start(args, format);
    __lm_log(log_ferr, file, line, sys, "***\t", format, &args);
    va_end(args);
}

#endif                          /* defined(LM_USE_LOGGER) */

#endif
