/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: lmdebug.h,v 1.9 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#include <liblm_config.h>

#ifndef _LMDEBUG_H
#define _LMDEBUG_H

/************************************/
/* BEGIN PUBLIC FUNCTIONS AND TYPES */
/************************************/

/* Compile time errors/warnings */
#define LM_CWARN(expr) 
#define LM_CASSERT(expr)
#define LM_CERROR(expr)

/* Run time information/assertion/checking functions */
#define LM_ASSERT(expr) _LM_ASSERT(expr)
#define LM_WARN(expr) _LM_WARN(expr)
#define LM_INFORM(expr) _LM_INFORM(expr)
#define LM_NULLPTR(expr) _LM_NULLPTR(expr)
#define LM_BREAK _LM_BREAK

/**********************************/
/* END PUBLIC FUNCTIONS AND TYPES */
/**********************************/

#if defined(_LMDEBUG) && defined(LM_USE_DEBUG)

#define _LM_ASSERT(expr) if(!(expr)) _lm_assert(__FILE__, __LINE__, #expr)
#define _LM_WARN(expr) if((expr)) _lm_warn(__FILE__, __LINE__, #expr)
#define _LM_INFORM(expr) if((expr)) _lm_inform(__FILE__, __LINE__, #expr)
#define _LM_BREAK _lm_break(__FILE__, __LINE__)

/* Internal functions to be called from above macros only */
void _lm_assert(char *file, int line, char *expr);
void _lm_warn(char *file, int line, char *expr);
void _lm_inform(char *file, int line, char *expr);
void _lm_break(char *file, int expr);

#else  /* defined(_LMDEBUG) && defined(LM_USE_DEBUG) */

     /* Do nothing during non debug builds */     
#define _LM_ASSERT(expr) 
#define _LM_WARN(expr) 
#define _LM_INFORM(expr) 
#define _LM_BREAK 
   
#endif /* defined(_LMDEBUG) && defined(LM_USE_DEBUG) */
   
#endif /* _LM_DEBUG_H */

