/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: lmdebug.c,v 1.6 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/* Standard C includes */
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

/* Library includes */
#include <liblm.h>

#if defined(_LMDEBUG) && defined (LM_USE_DEBUG)

void _lm_assert(char *file, int line, char *expr)
{
    fprintf(stderr, "LM_ASSERT FAILED: \"%s\",  %s:%d\n", expr, file, line);
    fflush(stderr);
    exit(-1);
}

void _lm_warn(char *file, int line, char *expr)
{
    char buffer[4];

    fprintf(stderr, "LM_WARN: \"%s\",  %s:%d\n", expr, file, line);
    fprintf(stderr, "Continue execution? (y/N):");
    fflush(stderr);
    memset(buffer, 0, sizeof(buffer));
    if (fgets(buffer, sizeof(buffer), stdin) == NULL) {
        perror("cannot read response from console");
    }

    if (buffer[0] == 'N' || buffer[0] == '\n')
        buffer[0] = 'n';

    if (buffer[0] == 'n') {
        puts("Execution cancelled from LM_WARN");
        fflush(stderr);
        exit(0);
    }
}

void _lm_inform(char *file, int line, char *expr)
{
    fprintf(stderr, "LM_INFORM: \"%s\",  %s:%d\n", expr, file, line);
    fflush(stderr);
}

void _lm_break(char *file, int line)
{
    fprintf(stderr, "LM_BREAK: %s:%d\n", file, line);
    fflush(stderr);
    exit(0);
}

#endif                          /* defined(_LWDEBUG) && defined (LM_USE_DEBUG) */
