/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: lmconfig_flatfile.c,v 1.9 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/* C includes */
#include <stdlib.h>
#include <stdio.h>

/* liblm includes */
#include <liblm.h>

static int __lm_config_flatfile_open(void);
static int __lm_config_flatfile_close(void);
static int __lm_config_flatfile_read_string(lm_config_key_t key,
                                            lm_config_string_t * pstring,
                                            lm_config_string_t defval);
static int __lm_config_flatfile_read_number(lm_config_key_t key,
                                            lm_config_number_t * pnumber,
                                            lm_config_number_t defval);
static int __lm_config_flatfile_read_bool(lm_config_key_t key,
                                          lm_config_bool_t * pbool,
                                          lm_config_bool_t defval);
static int __lm_config_flatfile_write_string(lm_config_key_t key,
                                             lm_config_string_t string);
static int __lm_config_flatfile_write_number(lm_config_key_t key,
                                             lm_config_number_t number);
static int __lm_config_flatfile_write_bool(lm_config_key_t key,
                                           lm_config_bool_t bool);

/* Flatfile type variables and state */
static lm_string_t config_flatfile_filename;

int _lm_config_flatfile_set_param(lm_string_t filename)
{
    /* Check parameters */
    LM_STRING_ASSERT(filename);

    /* Check to be sure hte parameters arent' set  already */
    LM_WARN(config_flatfile_filename != NULL);

    /* Setup the parmeters for flatfile */
    LM_STRING_DUP(config_flatfile_filename, filename);

    _lm_config_set_functions(__lm_config_flatfile_open,
                             __lm_config_flatfile_close,
                             __lm_config_flatfile_read_string,
                             __lm_config_flatfile_read_number,
                             __lm_config_flatfile_read_bool,
                             __lm_config_flatfile_write_string,
                             __lm_config_flatfile_write_number,
                             __lm_config_flatfile_write_bool);

    /* Attempt to open flatfile type config database */
    return __lm_config_flatfile_open();
}

static int __lm_config_flatfile_open(void)
{
    /* Sanity check parameters */
    LM_STRING_ASSERT(config_flatfile_filename);
    return 0;
}

static int __lm_config_flatfile_close(void)
{
    /* Free the config variables */
    LM_STRING_FREE(config_flatfile_filename);

    return 0;
}

static int __lm_config_flatfile_read_string(lm_config_key_t key,
                                            lm_config_string_t * pstring,
                                            lm_config_string_t defval)
{
    lm_config_string_t newstr = NULL;

    SYSLOG((LOG_ERR, "FLATFILE READ STRING NOT IMPLEMENTED!!! USING DEFAULT!"));

    LM_STRING_DUP(newstr, defval);
    if (*pstring != NULL) {
        lm_string_t tmpstring;

        tmpstring = *pstring;
        LM_STRING_FREE(tmpstring);
    }

    *pstring = newstr;
    return *pstring == NULL;
}

static int __lm_config_flatfile_read_number(lm_config_key_t key,
                                            lm_config_number_t * pnumber,
                                            lm_config_number_t defval)
{
    SYSLOG((LOG_ERR, "FLATFILE READ NUMBER NOT IMPLEMENTED!!! USING DEFAULT!"));
    *pnumber = defval;
    return -1;
}

static int __lm_config_flatfile_read_bool(lm_config_key_t key,
                                          lm_config_bool_t * pbool,
                                          lm_config_bool_t defval)
{
    SYSLOG((LOG_ERR, "FLATFILE READ BOOL NOT IMPLEMENTED!!! USING DEFAULT!"));
    *pbool = defval;
    return -1;
}

static int __lm_config_flatfile_write_string(lm_config_key_t key,
                                             lm_config_string_t string)
{
    SYSLOG((LOG_ERR, "FLATFILE WRITE STRING NOT IMPLEMENTED!!!"));
    return -1;
}

static int __lm_config_flatfile_write_number(lm_config_key_t key,
                                             lm_config_number_t number)
{
    SYSLOG((LOG_ERR, "FLATFILE WRITE NUMBER NOT IMPLEMENTED!!!"));
    return -1;
}

static int __lm_config_flatfile_write_bool(lm_config_key_t key,
                                           lm_config_bool_t bool)
{
    SYSLOG((LOG_ERR, "FLATFILE WRITE BOOL NOT IMPLEMENTED!!!"));
    return -1;
}
