/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: lmconfig_env.c,v 1.7 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/* C includes */
#include <stdlib.h>
#include <stdio.h>

/* liblm includes */
#include <liblm.h>

static int __lm_config_env_open(void);
static int __lm_config_env_close(void);
static int __lm_config_env_read_string(lm_config_key_t key,
                                       lm_config_string_t * pstring,
                                       lm_config_string_t defval);
static int __lm_config_env_read_number(lm_config_key_t key,
                                       lm_config_number_t * pnumber,
                                       lm_config_number_t defval);
static int __lm_config_env_read_bool(lm_config_key_t key,
                                     lm_config_bool_t * pbool,
                                     lm_config_bool_t defval);
static int __lm_config_env_write_string(lm_config_key_t key,
                                        lm_config_string_t string);
static int __lm_config_env_write_number(lm_config_key_t key,
                                        lm_config_number_t number);
static int __lm_config_env_write_bool(lm_config_key_t key,
                                      lm_config_bool_t bool);

int _lm_config_env_set_param(void)
{
    _lm_config_set_functions(__lm_config_env_open, __lm_config_env_close,
                             __lm_config_env_read_string,
                             __lm_config_env_read_number,
                             __lm_config_env_read_bool,
                             __lm_config_env_write_string,
                             __lm_config_env_write_number,
                             __lm_config_env_write_bool);

    /* Attempt to open a env type config */
    return __lm_config_env_open();
}

static int __lm_config_env_open(void)
{
    return 0;
}

static int __lm_config_env_close(void)
{
    return 0;
}

static int __lm_config_env_read_string(lm_config_key_t key,
                                       lm_config_string_t * pstring,
                                       lm_config_string_t defval)
{
    char *var = NULL;
    lm_config_string_t newstr = NULL;

    LM_STRING_ASSERT(key);
    LM_STRING_ASSERT(defval);

    /* Attempt to get the environment variable specified by key */
    var = getenv(LM_STRING_BUFFER(key));
    if (var == NULL) {
        /* Warn the user the variable didn't exist and we're using the default value */
        SYSLOG((LOG_DEBUG,
                "Couldn't find string environment variable...using default!"));
        LM_STRING_DUP(newstr, defval);
        if (newstr == NULL)
            return -1;
    } else {
        /* Make a new string from the returned string variable */
        LM_STRING_NEW(newstr, var);
    }

    /* If a string was already allocated in pstring free it */
    if (*pstring != NULL) {
        lm_string_t tmpstring;

        tmpstring = *pstring;
        LM_STRING_FREE(tmpstring);
    }

    *pstring = newstr;
    return *pstring == NULL;
}

static int __lm_config_env_read_number(lm_config_key_t key,
                                       lm_config_number_t * pnumber,
                                       lm_config_number_t defval)
{
    char *var;

    LM_STRING_ASSERT(key);
    var = getenv(LM_STRING_BUFFER(key));
    if (var == NULL) {
        SYSLOG((LOG_DEBUG,
                "Couldn't find number environment variable...using default!"));
        *pnumber = defval;
    } else {
        lm_string_t newstr = NULL;
        int readval;

        /* Convert the environment variable to a string */
        LM_STRING_NEW(newstr, var);
        if (newstr == NULL)
            return -1;

        /* Control file was read sucessfully, now convert the number from text to binary */
        if (LM_STRING_TO_INT(newstr, readval)) {
            SYSLOG((LOG_DEBUG,
                    "Asking for number from environment variable which does not contain a number...using default!"));
            *pnumber = defval;
        } else {
            *pnumber = readval;
        }
        LM_STRING_FREE(newstr);
    }

    return 0;
}

static int __lm_config_env_read_bool(lm_config_key_t key,
                                     lm_config_bool_t * pbool,
                                     lm_config_bool_t defval)
{
    SYSLOG((LOG_WARNING, "ENV READ BOOL NOT IMPLEMENTED!!! USING DEFAULT!"));
    *pbool = defval;
    return 0;
}

static int __lm_config_env_write_string(lm_config_key_t key,
                                        lm_config_string_t string)
{
    SYSLOG((LOG_WARNING, "ENV WRITE STRING NOT IMPLEMENTED!!!"));
    return -1;
}

static int __lm_config_env_write_number(lm_config_key_t key,
                                        lm_config_number_t number)
{
    SYSLOG((LOG_WARNING, "ENV WRITE NUMBER NOT IMPLEMENTED!!!"));
    return -1;
}

static int __lm_config_env_write_bool(lm_config_key_t key,
                                      lm_config_bool_t bool)
{
    SYSLOG((LOG_WARNING, "ENV WRITE BOOL NOT IMPLEMENTED!!!"));
    return -1;
}
