/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: lmconfig.h,v 1.18 2003/09/24 21:10:36 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#include <liblm_config.h>


#if defined(USE_LM_CONFIG_DATABASE)
#include <postgresql/libpq-fe.h>
#endif

#ifndef _LMCONFIG_H
#define _LMCONFIG_H

#ifdef LM_USE_CONFIG

/************************************/
/* BEGIN PUBLIC FUNCTIONS AND TYPES */
/************************************/

/* Standard configuration file data key types */
typedef lm_string_t lm_config_key_t;
typedef lm_string_t lm_config_string_t;
typedef unsigned char lm_config_bool_t;
typedef int lm_config_number_t;

/* Specific for setting database type config variables */
#define LM_CONFIG_FLATFILE_SET_PARAM(filename) _LM_CONFIG_FLATFILE_SET_PARAM(filename)

/* Specific for setting database type config variables */
#define LM_CONFIG_DB_SET_PARAM(database,table,selectcol,keycol,where) \
_LM_CONFIG_DB_SET_PARAM(database,table,selectcol,keycol,where)

/* Specific for setting control file type config variables */
#define LM_CONFIG_CONTROL_SET_PARAM(controldir) _LM_CONFIG_CONTROL_SET_PARAM(controldir)

/* Specific for setting env file type config variables */
#define LM_CONFIG_ENV_SET_PARAM _LM_CONFIG_ENV_SET_PARAM

/* Get the current configuration type */
#define LM_CONFIG_CLOSE _LM_CONFIG_CLOSE

/* Functions for accessing key data from configuration */
#define LM_CONFIG_READ_STRING(key,string,defval) _LM_CONFIG_READ_STRING(key,string,defval)
#define LM_CONFIG_WRITE_STRING(key,string) _LM_CONFIG_WRITE_STRING(key, string)

#define LM_CONFIG_READ_NUMBER(key,number,defval) _LM_CONFIG_READ_NUMBER(key,number,defval)
#define LM_CONFIG_WRITE_NUMBER(key,number) _LM_CONFIG_WRITE_NUMBER(key, number)

#define LM_CONFIG_READ_BOOL(key,bool,defval) _LM_CONFIG_READ_BOOL(key,bool,defval)
#define LM_CONFIG_WRITE_BOOL(key,bool) _LM_CONFIG_WRITE_BOOL(key, bool)

/**********************************/
/* END PUBLIC FUNCTIONS AND TYPES */
/**********************************/

/* Debug versions write extra information to the log file when called */
#if defined(_LMDEBUG)

#define _LM_CONFIG_CLOSE _lm_config_close_debug(__FILE__,__LINE__);
#define _LM_CONFIG_CHECK_TYPE(type) _lm_config_check_type_debug(__FILE__, __LINE__, type)
#define _LM_CONFIG_SET_TYPE(type) _lm_config_set_type_debug(__FILE__, __LINE__, type)

#define _LM_CONFIG_FLATFILE_SET_PARAM(filename) _lm_config_flatfile_set_param_debug(__FILE__,__LINE__,filename)
#define _LM_CONFIG_CONTROL_SET_PARAM(confdir) _lm_config_control_set_param_debug(__FILE__,__LINE__,confdir)
#define _LM_CONFIG_ENV_SET_PARAM _lm_config_env_set_param_debug(__FILE__,__LINE__)

#define _LM_CONFIG_READ_STRING(key,string,defval) _lm_config_read_string_debug(__FILE__,__LINE__,key,&string,defval)
#define _LM_CONFIG_WRITE_STRING(key,string) _lm_config_write_string_debug(__FILE__,__LINE__,key,string)

#define _LM_CONFIG_READ_NUMBER(key,number,defval) _lm_config_read_number_debug(__FILE__,__LINE__,key,&number,defval)
#define _LM_CONFIG_WRITE_NUMBER(key,number) _lm_config_write_number_debug(__FILE__,__LINE__,key,number)

#define _LM_CONFIG_READ_BOOL(key,bool,defval) _lm_config_read_bool_debug(__FILE__,__LINE__,key,&bool,defval)
#define _LM_CONFIG_WRITE_BOOL(key,bool) _lm_config_write_bool_debug(__FILE__,__LINE__,key,bool)

int _lm_config_close_debug(char *file, int line);

int _lm_config_flatfile_set_param_debug(char *file, int line, lm_string_t filename);
int _lm_config_control_set_param_debug(char* file, int line, lm_string_t controldir);
int _lm_config_env_set_param_debug(char* file, int line);

int _lm_config_read_string_debug(char *file, int line, lm_config_key_t key, lm_config_string_t* pstring, lm_config_string_t defval);
int _lm_config_read_number_debug(char *file, int line, lm_config_key_t key, lm_config_number_t* pnumber, lm_config_number_t defaval);
int _lm_config_read_bool_debug(char *file, int line, lm_config_key_t key, lm_config_bool_t* pbool, lm_config_bool_t defval);

int _lm_config_write_string_debug(char *file, int line, lm_config_key_t key, lm_config_string_t string);
int _lm_config_write_number_debug(char *file, int line, lm_config_key_t key, lm_config_number_t number);
int _lm_config_write_bool_debug(char *file, int line, lm_config_key_t key, lm_config_bool_t bool);

#else  /* defined(_LMDEBUG) */

/* Took these out of main interface and changed them to internal */
#define _LM_CONFIG_FLATFILE_SET_PARAM(type) _lm_config_flatfile_set_param(type)
#define _LM_CONFIG_CONTROL_SET_PARAM(dir) _lm_config_control_set_param(dir)
#define _LM_CONFIG_ENV_SET_PARAM _lm_config_env_set_param()

#define _LM_CONFIG_CLOSE _lm_config_close();

#define _LM_CONFIG_READ_STRING(key,string,defval) _lm_config_read_string(key,&string,defval)
#define _LM_CONFIG_WRITE_STRING(key,string) _lm_config_write_string(key,string)

#define _LM_CONFIG_READ_NUMBER(key,number,defval) _lm_config_read_number(key,&number,defval)
#define _LM_CONFIG_WRITE_NUMBER(key,number) _lm_config_write_number(key,number)

#define _LM_CONFIG_READ_BOOL(key,bool,defval) _lm_config_read_bool(key,&bool,defval)
#define _LM_CONFIG_WRITE_BOOL(key,bool) _lm_config_write_bool(key,bool)

int _lm_config_close(void);

int _lm_config_read_string(lm_config_key_t key, lm_config_string_t* pstring, lm_config_string_t defval);
int _lm_config_read_number(lm_config_key_t key, lm_config_number_t* pnumber, lm_config_number_t defval);
int _lm_config_read_bool(lm_config_key_t key, lm_config_bool_t* pbool, lm_config_bool_t defval);

int _lm_config_write_string(lm_config_key_t key, lm_config_string_t string);
int _lm_config_write_number(lm_config_key_t key, lm_config_number_t number);
int _lm_config_write_bool(lm_config_key_t key, lm_config_bool_t bool);


#endif /* defined(_LMDEBUG) */

#if defined(USE_LM_CONFIG_DATABASE)
#ifdef _LMDEBUG
int _lm_config_db_set_param_debug(char *file, int line, 
		PGconn *database, char * table,
		lm_string_t selectcol, lm_string_t keycol, lm_string_t where);
#define _LM_CONFIG_DB_SET_PARAM(database,table,selectcol,keycol,where) \
	_lm_config_db_set_param_debug(__FILE__,__LINE__,database,table,selectcol,keycol,where)
#else  /* _LMDEBUG */
#define _LM_CONFIG_DB_SET_PARAM(database,table,selectcol,keycol,where) \
	_lm_config_db_set_param(database,table,selectcol,keycol,where)
#endif
int _lm_config_db_set_param(PGconn *database, char * table,
		lm_string_t selectcol, lm_string_t keycol, lm_string_t where);
#endif /* defined(USE_LM_CONFIG_DATABASE) */

#if defined(USE_LM_CONFIG_CONTROL)
int _lm_config_control_set_param(lm_string_t controldir);
#endif /* defined(USE_LM_CONFIG_CONTROL) */

#if defined(USE_LM_CONFIG_FLATFILE)
int _lm_config_flatfile_set_param(lm_string_t filename);
#endif /* defined(USE_LM_CONFIG_FLATFILE) */

#if defined(USE_LM_CONFIG_ENV)
int _lm_config_env_set_param(void);
#endif /* defined(USE_LM_CONFIG_ENV) */

/* Don't call this! */
int _lm_config_set_functions(void*, void*, void*, void*, void*, void*, void*, void*);

#endif /* LM_USE_CONFIG */

#endif /* _LM_CONFIG_H */
