/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: lmconfig.c,v 1.18 2003/09/24 21:10:36 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/* C includes */
#include <stdlib.h>

/* liblm includes */
#define LM_USE_LOGGER
#define LM_USE_STRING
#include <liblm.h>

/* Function pointers to read/write config
 These are setup on by each specific configuration type when opened */
static int (*__config_open) (void);
static int (*__config_close) (void);
static int (*__config_read_string) (lm_string_t key,
                                    lm_config_string_t * pstring,
                                    lm_config_string_t defval);
static int (*__config_read_number) (lm_string_t key,
                                    lm_config_number_t * pnumber,
                                    lm_config_number_t defval);
static int (*__config_read_bool) (lm_string_t key, lm_config_bool_t * pbool,
                                  lm_config_bool_t defval);
static int (*__config_write_string) (lm_string_t key,
                                     lm_config_string_t string);
static int (*__config_write_number) (lm_string_t key,
                                     lm_config_number_t number);
static int (*__config_write_bool) (lm_string_t key, lm_config_bool_t * bool);

/* Close the configuration database */
int _lm_config_close(void)
{
    /* Close the open database */
    LM_ASSERT(__config_close);
    if (__config_close()) {
        SYSLOG((LOG_ERR, "Could not close config database!"));
        return -1;
    }

    return 0;
}

int _lm_config_read_string(lm_config_key_t key, lm_config_string_t * pstring,
                           lm_config_string_t defval)
{
    LM_ASSERT(__config_read_string != NULL);
    return __config_read_string(key, pstring, defval);
}

int _lm_config_read_number(lm_config_key_t key, lm_config_number_t * pnumber,
                           lm_config_number_t defval)
{
    LM_ASSERT(__config_read_number != NULL);
    return __config_read_number(key, pnumber, defval);
}

int _lm_config_read_bool(lm_config_key_t key, lm_config_bool_t * pbool,
                         lm_config_bool_t defval)
{
    LM_ASSERT(__config_read_bool != NULL);
    return __config_read_bool(key, pbool, defval);
}

int _lm_config_write_string(lm_config_key_t key, lm_config_string_t string)
{
    return 0;
}

int _lm_config_write_number(lm_config_key_t key, lm_config_number_t number)
{
    return 0;
}

int _lm_config_write_bool(lm_config_key_t key, lm_config_bool_t bool)
{
    return 0;
}

#if defined _LMDEBUG

int _lm_config_close_debug(char *file, int line)
{
    SYSLOG((LOG_DEBUG, "lmconfig_close"));
    return _lm_config_close();
}

int _lm_config_flatfile_set_param_debug(char *file, int line,
                                        lm_string_t filename)
{

    SYSLOG((LOG_DEBUG, "lmconfig_set_flatfile_param: filename = %s",
            LM_STRING_BUFFER(filename)));
    return _lm_config_flatfile_set_param(filename);
}

#ifdef USE_LM_DATABASE
int _lm_config_db_set_param_debug(char *file, int line, PGconn * database,
                                  char *table, lm_string_t selectcol,
                                  lm_string_t keycol, lm_string_t where)
{

    SYSLOG((LOG_DEBUG,
            "lmconfig_set_db_param: selectcol = %s, keycol = %s, where = %s",
            LM_STRING_BUFFER(selectcol), LM_STRING_BUFFER(keycol),
            LM_STRING_BUFFER(where)));
    return _lm_config_db_set_param(database, table, selectcol, keycol, where);
}
#endif                          /* USE_LM_DATABASE */

int _lm_config_control_set_param_debug(char *file, int line,
                                       lm_string_t controldir)
{
    SYSLOG((LOG_DEBUG, "lmconfig_set_control_param: controldir = %s",
            LM_STRING_BUFFER(controldir)));
    return _lm_config_control_set_param(controldir);
}

int _lm_config_env_set_param_debug(char *file, int line)
{
    SYSLOG((LOG_DEBUG, "lmconfig_set_env_param"));
    return _lm_config_env_set_param();
}

int _lm_config_read_string_debug(char *file, int line, lm_config_key_t key,
                                 lm_config_string_t * pstring,
                                 lm_config_string_t defval)
{
    int retval;

    retval = _lm_config_read_string(key, pstring, defval);

    SYSLOG((LOG_DEBUG,
            "lm_config_read_string: key = %s, value = \"*notshown*\"",
            LM_STRING_BUFFER(key)));

    return retval;
}

int _lm_config_read_number_debug(char *file, int line, lm_config_key_t key,
                                 lm_config_number_t * pnumber,
                                 lm_config_number_t defval)
{
    int retval;

    retval = _lm_config_read_number(key, pnumber, defval);

    SYSLOG((LOG_DEBUG, "lm_config_read_number: key = %s, value = %d",
            LM_STRING_BUFFER(key), *pnumber));

    return retval;
}

int _lm_config_read_bool_debug(char *file, int line, lm_config_key_t key,
                               lm_config_bool_t * pbool,
                               lm_config_bool_t defval)
{
    int retval;

    retval = _lm_config_read_bool(key, pbool, defval);

    SYSLOG((LOG_DEBUG, "lm_config_read_bool: key = %s, value = %s",
            LM_STRING_BUFFER(key), *pbool ? "true" : "false"));

    return retval;
}

int _lm_config_write_string_debug(char *file, int line, lm_config_key_t key,
                                  lm_config_string_t string)
{
    SYSLOG((LOG_DEBUG, "lm_config_write_string: key = %s, value = \"%s\"",
            LM_STRING_BUFFER(key), LM_STRING_BUFFER(string)));
    return _lm_config_write_string(key, string);
}

int _lm_config_write_number_debug(char *file, int line, lm_config_key_t key,
                                  lm_config_number_t number)
{
    SYSLOG((LOG_DEBUG, "lm_config_write_number: key = %s, value = %d",
            LM_STRING_BUFFER(key), number));
    return _lm_config_write_number(key, number);
}

int _lm_config_write_bool_debug(char *file, int line, lm_config_key_t key,
                                lm_config_bool_t bool)
{
    SYSLOG((LOG_DEBUG, "lm_config_write_number: key = %s, value = %s",
            LM_STRING_BUFFER(key), bool ? "true" : "false"));
    return _lm_config_write_bool(key, bool);
}

#endif                          /* defined(_LMDEBUG) */

/* TODO Write properly!!! */
int _lm_config_set_functions(void *fopen, void *fclose, void *fread_string,
                             void *fread_number, void *fread_bool,
                             void *fwrite_string, void *fwrite_number,
                             void *fwrite_bool)
{
    __config_open = fopen;
    __config_close = fclose;
    __config_read_string = fread_string;
    __config_read_number = fread_number;
    __config_read_bool = fread_bool;
    __config_write_string = fwrite_string;
    __config_write_number = fwrite_number;
    __config_write_bool = fwrite_bool;

    return 0;
}
