/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: lmalloc.h,v 1.13 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#include <sys/types.h>
#include <stdio.h>
#include <malloc.h>

#include <liblm_config.h>

#ifndef _LMALLOC_H
#define _LMALLOC_H

/************************************/
/* BEGIN PUBLIC FUNCTIONS AND TYPES */
/************************************/

#define LM_MALLOC(ptr, size) _lm_malloc(size, (void**)(&ptr), #ptr, __FILE__, __LINE__)
#define LM_CALLOC(ptr, size) _lm_calloc(size, (void**)(&ptr), #ptr, __FILE__, __LINE__)
#define LM_FREE(ptr) _lm_free((void**)&ptr, #ptr, __FILE__, __LINE__)
/* NOTE: We do not define LM_REALLOC because this function is dangerous
   and should never be used */

/* Checks the integrity of the memory block to stderr */
#define LM_MEMASSERT(ptr) _lm_memassert(ptr, #ptr, __FILE__, __LINE__)

/* Prints information about a memory block to stderr */
#define LM_MEMINFO(ptr, outfile) _lm_meminfo(outfile, ptr, #ptr, __FILE__, __LINE__)

/* Prints memory allocation statistics  */
#define LM_MEMSTAT(outfile) _lm_memstat(outfile, __FILE__, __LINE__)

/* Prints information about a memory block to stderr */
#define LM_MEMDUMP(outfile)  _lm_memdump(outfile, __FILE__, __LINE__)

/**********************************/
/* END PUBLIC FUNCTIONS AND TYPES */
/**********************************/

#if defined(_LMDEBUG) && defined (LM_USE_ALLOC)

/* Internal functions to be called from above macros */
int _lm_malloc(size_t size, void **pptr, char *sym, char *file, int line);
int _lm_calloc(size_t size, void **pptr, char *sym, char *file, int line);
void _lm_free(void **pptr, char *expr, char *file, int line);

/* Memory allocation block information functions */
void _lm_memassert(void *ptr, char *expr, char *file, int line);
void _lm_meminfo(FILE *outfile, void *ptr, char *expr, char *file, int line);
void _lm_memstat(FILE* outfile, char *file, int line);
void _lm_memdump(FILE* outfile, char *file, int line);

#else /* ! _LM_DEBUG && USE_LM_ALLOC */

/* Non debug builds always just use default library functions  */
#define _lm_malloc(size,pptr,sym,file,line) ((*pptr = malloc(size)) == NULL)
#define _lm_calloc(size,pptr,sym, file,line) ((*pptr = calloc(1, size)) == NULL)
#define _lm_free(pptr,sym,file,line) free(*pptr);(*pptr)=NULL;

#define _lm_memassert(ptr,sym, file,line) 
#define _lm_meminfo(outfile,ptr,file,line) 
#define _lm_memstat(outfile,file,line) 
#define _lm_memdump(outfile,file,line) 

#endif /* _LM_DEBUG && USE_LM_ALLOC */

#endif /* _LM_ALLOC_H */
