
/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Josh Wilsdon <josh@wizard.ca>
 *
 * CVS Id: $Id: libgetbdb.h,v 1.5 2003/10/22 22:34:08 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#ifndef LIB_GETBDB_H
#define LIB_GETBDB_H

#include <db.h>

typedef struct {
    char *password;
    unsigned int uid;
    unsigned int gid;
    char *dir;
    char *quota;
} user_record_t;

DB *openDBFile(char *filename);
int closeDBFile(DB *dbp);
int getData(DB *dbp, unsigned int dbkeylen, char *dbkey, unsigned int *dbdatalen, char **dbdata);
int getKeyMangledData(DB *dbp, char *dbkey, char manglechar, unsigned int *dbdatalen, char **dbdata);
int getUserData(DB *dbp, char *user, unsigned int *dbdatalen, char **dbdata);
int getAliasData(DB *dbp, char *alias, unsigned int *dbdatalen, char **dbdata);
int getSpamEmailID(DB *dbp, char *email, unsigned int *dbdatalen, char **dbdata);
int getVirusEmailID(DB *dbp, char *email, unsigned int *dbdatalen, char **dbdata);
int getSpamRules(DB *dbp, char *email_id, unsigned int *dbdatalen, char **dbdata);
int getRealUser(DB *dbp, char *user, char **realuser);
int getUserStruct(DB *dbp, char *user, user_record_t *user_rec);

#endif
