/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * Copyright (c) 2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Authors: John Bratlien <john@wizard.ca>
 *          Josh Wilsdon <josh@wizard.ca>
 *
 * Version: $Id: ip2country.c,v 1.7 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 *
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <string.h>
#include <netinet/in.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>
#include "ip2country.h"

/* TODO: 
 *
 *  design an error string framework into ccdata
 *
 */

/* local functions */
static int inet_ntocc(ccdata_t ccdata, unsigned long int inet_n, char *cc);

#ifdef TESTING
int main(int argc, char *argv[])
{
    /* pad the end with null */
    char country[3];
    ccdata_t ccdata;

    ccdata = initGetCC();
    if (ccdata == NULL) {
        printf("initGetCC() Failed\n");
        exit(1);
    }

    if (getCC(ccdata, argv[1], country) != 0) {
        printf("inet_atocc(%s) failed\n", argv[1]);
    }

    printf("country code[%s]\n", country);

    destroyCC(ccdata);

    return 0;
}
#endif

void destroyCC(ccdata_t ccdata)
{
    if (ccdata == NULL) {
        return;
    }

    if (ccdata->ipfile != NULL) {
        fclose(ccdata->ipfile);
    }

    free(ccdata);

    return;
}

int getCC(ccdata_t ccdata, char *host, char *cc)
{
    int len;
    struct hostent *h;
    struct in_addr in;

    if ((host == NULL) || (cc == NULL)) {
        return (1);             /* invalid input */
    }

    len = strlen(host);
    if ((len > 3) && isalpha(host[len - 1])
        && isalpha(host[len - 2])
        && (host[len - 3] == '.')) {
        /* it ends in ".XX" so the last 2 characters are the country code */
        cc[0] = toupper(host[len - 2]);
        cc[1] = toupper(host[len - 1]);
        return (0);             /* success */
    }

    if ((h = gethostbyname(host)) != NULL) {
        in = *((struct in_addr *) h->h_addr);
#ifdef TESTING
        printf("looking up: %s\n", inet_ntoa(in));
#endif
        if (inet_ntocc(ccdata, in.s_addr, cc) == 0) {
            return (0);         /* success */
        }
    }

    cc[0] = cc[1] = '*';
    return (1);                 /* failure */
}

/* TODO: this function is a mess and should be re-written */
int inet_ntocc(ccdata_t ccdata, unsigned long int inet_n, char *cc)
{
    unsigned long int pos = 4;
    unsigned char bit0 = 128, bit1 = 64;

    int i;
    unsigned char byte_zero, c;
    union {
        unsigned long fourBytes;
        unsigned char byte[4];
    } byteManip;

    byteManip.fourBytes = 0;

    /* do error checking for fseek() */
    if (fseek(ccdata->ipfile, pos, SEEK_SET) != 0) {
        syslog(LOG_ERR, "inet_ntocc(): fseek failed\n");
        return (1);
    }

    /*
       printf("inet_n: %lu\n", inet_n);
       for every fgetc() the filePtr is advanced by 1
       remember to subtract 1 from pos 
     */
    byte_zero = fgetc(ccdata->ipfile);

    /* printf("**byte_zero: %i\n", byte_zero); */

    for (i = 0; i < 32; i++) {
        if ((inet_n & (unsigned long int) ccdata->mask[i]) ==
            (unsigned long int) ccdata->mask[i]) {
            /* if (debug) printf ("byte0 (if#1) %u", byte_zero); */
            /* if (debug) printf (" pos %u\n", pos); */
            if ((byte_zero & bit1) == bit1) {
                /* if (debug) printf("if#1 (sub if) "); */
                pos = pos + 1 + (byte_zero ^ bit1);
            } else {
                /* if (debug) printf("if#1 (sub else) "); */
                fseek(ccdata->ipfile, pos, SEEK_SET);
                /* check byte ordering */
                byteManip.byte[1] = fgetc(ccdata->ipfile);
                byteManip.byte[2] = fgetc(ccdata->ipfile);
                byteManip.byte[3] = fgetc(ccdata->ipfile);
                byteManip.byte[0] = 0;
                byteManip.fourBytes = htonl(byteManip.fourBytes);
                pos = pos + 3 + byteManip.fourBytes;
            }
            /* if (debug) printf("pos (after if#1): %u\t", pos); */
        } else {
            /* if (debug) printf("else (if test) %i", ((byte_zero & bit1) == bit1)); */
            if ((byte_zero & bit1) == bit1) {
                pos = pos + 1;
            } else {
                pos = pos + 3;
            }
            /* if (debug) printf("pos (after else#1):%i\t", pos); */
        }
        fseek(ccdata->ipfile, pos, SEEK_SET);
        byte_zero = fgetc(ccdata->ipfile);
        /* if (debug) printf("byte0 (after R): %u\n", byte_zero); */

        if ((byte_zero & bit0) == bit0) {
            if ((byte_zero & bit1) == bit1) {
                /* unpopular country code - stored in second byte */
                fseek(ccdata->ipfile, pos + 1, SEEK_SET);
                c = fgetc(ccdata->ipfile);

                cc[0] = ccdata->cctable[c].twoChars[0];
                cc[1] = ccdata->cctable[c].twoChars[1];
                return (0);
            } else {
                /* 
                   popular country code - stored in bits 2-7
                   (we already know that bit 1 is not set, so
                   just need to unset bit1)
                 */
                cc[0] = ccdata->cctable[(byte_zero ^ bit0)].twoChars[0];
                cc[1] = ccdata->cctable[(byte_zero ^ bit0)].twoChars[1];
                return (0);
            }
        }
    }
    return (1);
}

ccdata_t initGetCC()
{
    int i;
    struct stat statinfo;
    unsigned char c, key;
    FILE *ccfile;
    ccdata_t new;

    new = malloc(sizeof(*new));
    if (new == NULL) {
        return (NULL);
    }

    for (i = 0; i < 32; i++)
        new->mask[i] = htonl((1 << (31 - i)));

    for (i = 0; i < 256; i++)
        new->cctable[i].twoChars[0] = new->cctable[i].twoChars[1] = '*';

    if ((ccfile = fopen(CC_GIF, "r")) == NULL) {
        syslog(LOG_ERR, "Could not open cc.gif");
        free(new);
        return (NULL);
    }

    if (fstat(fileno(ccfile), &statinfo) != 0) {
        syslog(LOG_ERR, "Could not stat cc.gif");
        free(new);
        return (NULL);
    }

    for (i = 0; i < (statinfo.st_size / 3); i++) {
        /* get the key */
        fseek(ccfile, 3 * i, SEEK_SET);
        key = fgetc(ccfile);

        /* get first byte */
        fseek(ccfile, (3 * i) + 1, SEEK_SET);
        c = fgetc(ccfile);
        new->cctable[key].twoChars[0] = c;

        /* .. second byte */
        fseek(ccfile, 3 * i + 2, SEEK_SET);
        c = fgetc(ccfile);
        new->cctable[key].twoChars[1] = c;
    }
    fclose(ccfile);

    new->ipfile = fopen(IP_GIF, "r");
    if (new->ipfile == NULL) {
        syslog(LOG_ERR, "Could not open ip.gif");
        free(new);
        return (NULL);
    }

    return (new);
}
