#!/bin/sed -f

#
# COPYRIGHT INFORMATION - DO NOT REMOVE
# "Portions Copyright (c) 2000-2001 LinuxMagic Inc. All Rights Reserved.
#
# This file contains Original Code and/or Modifications of Original Code as
# defined in and that are subject to the Free Source Code License Version
# 1.0 (the 'License'). You may not use this file except in compliance with
# the License. Please obtain a copy of the License at:
#
# http://www.linuxmagic.com/opensource/licensing/FSCL.txt
#
# and read it before using this file.
#
# The Original Code and all software distributed under the License are
# distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
# the License for the specific language governing rights and limitations
# under the License."
#
# Please read the terms of this license carefully. By using or downloading
# this software or file, you are accepting and agreeing to the terms of this
# license with LinuxMagic Inc. If you are agreeing to this license on behalf
# of a company, you represent that you are authorized to bind the company to
# such a license. If you do not meet this criterion or you do not agree to
# any of the terms of this license, do NOT download, distribute, use or alter
# this software or file in any way.
#
# Author: Burton Samograd (burton@wizard.ca)
# CVS Id: $Id: config_spam_rule_h.sed,v 1.10 2003/10/22 23:08:13 josh Exp $
#
# DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
#

#
# Script to generate config_spam_rule.h from config_spam_rule.in
#
# config_spam_rule.in format:
# format:
#	type name default (depends,...) # comment
# eg:
#bool spam_check 0 () #doesn't depend
#bool smtp_checks 1 (spam_check) #depends on spam check
#bool smtp_block 1 (smtp_check) #depends both spam and smtp check
#
# See LICENSCE for use and copying information.
#
# type name default <desc> # comment
#

#
# File header and structure start
#
1{
a \
/************************************************************/ \
/* This file has been automatically generated. DO NOT EDIT! */ \
/*                                                          */ \
/* See the file LICENCE for use and copying information.    */ \
/************************************************************/ \
\
\#include <liblm.h> \
\
\#include "strlist.h" \
\#ifndef _CONFIG_SPAM_RULE_H \
\#define _CONFIG_SPAM_RULE_H \
\
typedef struct tag_config_spam_rule_t \
\{
}

# Add a newline to the end of the file to prevent compilation errors
# if someone forgets
${
s/.*/\
/
}

#
# Footer: structure close and function declerations.
#
${
a \
\} config_spam_rule_t;\
\
int config_spam_rule_load(lm_string_t addr, \
		config_spam_rule_t *ruledata, lm_string_t spamdir); \
int config_spam_rule_free(config_spam_rule_t *ruledata); \
int config_spam_rule_read(config_spam_rule_t* globalrules, config_spam_rule_t *ruledata);\
\
extern config_spam_rule_t global_spam_rules; \
\
\#endif 
}

#
# Clean the input file 
#
{
# Strip comments and end of line whitespace
s/[[:space:]]*\#.*$//
# Strip beginning of line whitespace 
s/^[[:space:]]*//
# delete blank lines
/^$/d
}

#
# Generate the output lines
#
/^$/!{ # don't bother with blanks
# save the orginal string and create the variable definition 
h
s/^bool[[:space:]]\+\([[:alnum:]_]\+\).*/lm_config_bool_t \1;/p
s/^string[[:space:]]\+\([[:alnum:]_]\+\).*/lm_config_string_t \1;/p
s/^strlist[[:space:]]\+\([[:alnum:]_]\+\).*/strlist_t \1;/p

# get the string and uppercase
g;y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/
# create the default value define using the name of the variable and the given default 
s/^\([[:alnum:]]\+\)[[:space:]]\+\([[:alnum:]_]\+\)[[:space:]]\+\([^[:space:]]\+\)\(.*\)/\#define SPAM_CONTROL_\2_DEFAULT \3/p

# get orignal and create the control key name
g;s/^\([[:alnum:]]\+\)[[:space:]]\+\([[:alnum:]_]\+\)[[:space:]]\+\([^[:space:]]\+\)\(.*\)/\2/
# save and uppercase 
h; y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/
# put the define with a line continuation
s/.*/\#define SPAM_CONTROL_& \\/p
# get lowercase version put on the next line surrounded by quotes 
g;s/.*/"&"/
# newline
a \

}
