/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: config_qmail.h,v 1.9 2003/09/24 21:10:35 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/*
  This file should be included by all modules which need to know
  about the program state or configuration data.
*/

#include <liblm.h>

#include "strlist.h"

#ifndef _MSD_QMAIL_CONFIG_H
#define _MSD_QMAIL_CONFIG_H

#define QMAIL_TIMEOUT_DEFAULT 1200
#define QMAIL_DATABYTES_DEFAULT (LONG_MAX-1)

/* Key strings for config and environment variables */
/* These are all documented by qmail */
#define QMAIL_CONTROL_KEY_ME "me"
#define QMAIL_CONTROL_KEY_DEFAULTDOMAIN "defaultdomain"
#define QMAIL_CONTROL_KEY_SMTPGREETING "smtpgreeting"
#define QMAIL_CONTROL_KEY_LOCALIPHOST "localiphost"
#define QMAIL_CONTROL_KEY_TIMEOUTSMTPD "timeoutsmtpd"
#define QMAIL_CONTROL_KEY_RCPTHOSTS "rcpthosts"
#define QMAIL_CONTROL_KEY_MORERCPTHOSTS "morercpthosts"
#define QMAIL_CONTROL_KEY_BADMAILFROM "badmailfrom"
#define QMAIL_CONTROL_KEY_DATABYTES "databytes"
#define QMAIL_CONTROL_KEY_VIRTUALDOMAINS "virtualdomains"
#define QMAIL_CONTROL_KEY_LOCALS "locals"

#define QMAIL_ENV_KEY_DATABYTES "DATABYTES"
#define QMAIL_ENV_KEY_TCPREMOTEIP "TCPREMOTEIP"
#define QMAIL_ENV_KEY_TCPLOCALHOST "TCPLOCALHOST"
#define QMAIL_ENV_KEY_TCPLOCALIP "TCPLOCALIP"
#define QMAIL_ENV_KEY_TCPREMOTEHOST "TCPREMOTEHOST"
#define QMAIL_ENV_KEY_TCPREMOTEINFO "TCPREMOTEINFO"
#define QMAIL_ENV_KEY_RELAYCLIENT "RELAYCLIENT"

typedef struct tag_msd_qmail_config_t
{
    /* Variables from control files or environment */
  lm_config_string_t me;
  lm_config_string_t defaultdomain;
  lm_config_string_t smtpgreeting;
  lm_config_string_t localiphost;
  lm_config_number_t timeoutsmtpd;
  lm_config_string_t virtualdomains;
  lm_config_number_t databytes;

  strlist_t rcpthostslist;
  strlist_t badmailfromlist;
  
  /* Variables passed from tcpserver */
  lm_config_string_t tcplocalip;
  lm_config_string_t tcpremoteip;
  lm_config_string_t tcpremotehost;
  lm_config_string_t tcpremoteinfo;
  lm_config_string_t tcprelayclient;

} config_qmail_t;

int config_qmail_load(char *qmailcontroldir);

int config_qmail_cleanup(void);

extern config_qmail_t config_qmail;

#endif /*  _MSD_QMAIL_CONFIG */
