/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: config_qmail.c,v 1.16 2003/09/24 21:10:35 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/* C includes */
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include <sys/stat.h>

/* Library includes */
#include <liblm.h>

/* Project includes */
#include "config_common.h"
#include "config_msd.h"
#include "config_qmail.h"

/* Global configuration variables */
config_qmail_t config_qmail;
lm_config_string_t newline = NULL;
lm_config_string_t emptystring = NULL;

#ifdef USE_LM_DATABASE
#include "postgresdb.h"
lm_string_t dbkeycol = NULL;
lm_string_t dbselectcol = NULL;
lm_string_t dbwhere = NULL;
#endif

/* Local function definitions */
static int config_qmail_read(char *qmailcontroldir);

int config_qmail_load(char *qmailcontroldir)
{
    /* Initialize variables */
    config_qmail.smtpgreeting = NULL;
    config_qmail.localiphost = NULL;
    config_qmail.defaultdomain = NULL;
    config_qmail.timeoutsmtpd = QMAIL_TIMEOUT_DEFAULT;
    config_qmail.badmailfromlist = NULL;
    config_qmail.rcpthostslist = NULL;
    config_qmail.databytes = QMAIL_DATABYTES_DEFAULT;
    config_qmail.tcplocalip = NULL;
    config_qmail.tcpremoteip = NULL;
    config_qmail.tcpremotehost = NULL;
    config_qmail.tcpremoteinfo = NULL;
    config_qmail.tcprelayclient = NULL;
    LM_STRING_NEW(newline, "\n");
    LM_STRING_NEW(emptystring, "");

    return config_qmail_read(qmailcontroldir);
}

/* Clean up allocated memory */
int config_qmail_cleanup(void)
{
    LM_STRING_FREE(config_qmail.me);
    LM_STRING_FREE(config_qmail.smtpgreeting);
    LM_STRING_FREE(config_qmail.localiphost);
    LM_STRING_FREE(config_qmail.defaultdomain);
    LM_STRING_FREE(config_qmail.tcpremoteip);
    LM_STRING_FREE(config_qmail.tcplocalip);
    STRLIST_FREE(config_qmail.rcpthostslist);
    STRLIST_FREE(config_qmail.badmailfromlist);
    LM_STRING_FREE(config_qmail.tcpremotehost);
    LM_STRING_FREE(config_qmail.tcpremoteinfo);
    LM_STRING_FREE(config_qmail.virtualdomains);
    if (config_qmail.tcprelayclient) {
        LM_STRING_FREE(config_qmail.tcprelayclient);
    }
    return 0;
}

/* Perform checks on variables to make sure the values stored in them
   make sense, else print error message and return error */
int config_qmail_verify(config_qmail_t config)
{
    return 0;
}

static int config_qmail_read(char *qmailcontroldir)
{
    lm_config_string_t defunknown = NULL;
    lm_config_string_t tcplocaliptmp = NULL;
    lm_config_string_t rcpthosts = NULL;
    lm_config_string_t morercpthosts = NULL;
    lm_config_string_t badmailfrom = NULL;
    lm_string_t lmstringqmailcontroldir = NULL;

    LM_STRING_NEW(lmstringqmailcontroldir, qmailcontroldir);

    /* Open the qmail control directory and read the qmail control files */
    if (LM_CONFIG_CONTROL_SET_PARAM(lmstringqmailcontroldir)) {
        SYSLOG((LOG_ERR, "could not open qmail control directory %s", qmailcontroldir));
    }

    /* Setup a blank string for defaults values */
    LM_STRING_NEW(defunknown, "unknown");

    /* Read me from the config */
    if (config_read_string(QMAIL_CONTROL_KEY_ME, &config_qmail.me, emptystring)) {
        return -1;
    }

    /* me is a required control file, so return error if it doesn't exist */
    if (LM_STRING_LEN(config_qmail.me) == 0) {
        SYSLOG((LOG_ERR, "Qmail control file 'me' does not exist"));
        return -1;
    }

    /* Read the smtpgreeting from the config */
    if (config_read_string (QMAIL_CONTROL_KEY_DEFAULTDOMAIN, &config_qmail.defaultdomain,
         config_qmail.me)) {
        return -1;
    }

    /* Read the smtpgreeting from the config */
    if (config_read_string (QMAIL_CONTROL_KEY_SMTPGREETING, &config_qmail.smtpgreeting,
         config_qmail.me)) {
        return -1;
    }

    /* Read the localiphost from the config */
    if (config_read_string (QMAIL_CONTROL_KEY_LOCALIPHOST, &config_qmail.localiphost,
         config_qmail.me)) {
        return -1;
    }

    /* Read the timeoutsmtpd from the config */
    if (config_read_number (QMAIL_CONTROL_KEY_TIMEOUTSMTPD, &config_qmail.timeoutsmtpd,
         QMAIL_TIMEOUT_DEFAULT)) {
        return -1;
    }

    /* QMAIL */
    if (config_qmail.timeoutsmtpd < 0) {
        config_qmail.timeoutsmtpd = 1;
    }

    /* Read rcpthosts and morercpthosts control file */
    /* and build the rcpthosts string list */
    if (config_read_string(QMAIL_CONTROL_KEY_RCPTHOSTS, &rcpthosts, emptystring)
        || config_read_string(QMAIL_CONTROL_KEY_MORERCPTHOSTS, &morercpthosts,
                              emptystring) || LM_STRING_CAT(rcpthosts, newline)
        || LM_STRING_CAT(rcpthosts, morercpthosts)
        || LM_STRING_FREE(morercpthosts)
        || STRLIST_NEW(config_qmail.rcpthostslist, rcpthosts)
        || LM_STRING_FREE(rcpthosts)) {
        return -1;
    }

    /* Read virtualdomains control file */
    if (config_read_string (QMAIL_CONTROL_KEY_VIRTUALDOMAINS, &config_qmail.virtualdomains,
         emptystring)) {
        return -1;
    }

    /* Read badmailfrom control file */
    if (config_read_string (QMAIL_CONTROL_KEY_BADMAILFROM, &badmailfrom, emptystring)
        || STRLIST_NEW(config_qmail.badmailfromlist, badmailfrom)
        || LM_STRING_FREE(badmailfrom)) {
        return -1;
    }

    /* Read the databytes from the config */
    if (config_read_number (QMAIL_CONTROL_KEY_DATABYTES, &config_qmail.databytes,
         QMAIL_DATABYTES_DEFAULT)) {
        return -1;
    }

    /* Close the control current config */
    LM_CONFIG_CLOSE;

    /* Open the env config */
    if (LM_CONFIG_ENV_SET_PARAM) {
        SYSLOG((LOG_ERR,
                "could not open environment config -- serious problem!"));
    }

    /* Read the databytes from the environment */
    /* defaults to current value if not present in environment */
    if (config_read_number
        (QMAIL_ENV_KEY_DATABYTES, &config_qmail.databytes,
         config_qmail.databytes)) {
        return -1;
    }

    /* QMAIL */
    if (config_qmail.databytes == UINT_MAX) {
        config_qmail.databytes--;
    }

    /* Read the remote ip given by TCP server */
    if (config_read_string
        (QMAIL_ENV_KEY_TCPREMOTEIP, &config_qmail.tcpremoteip, defunknown)) {
        return -1;
    }

    /* Set the variable localip to TCPLOCALHOST if set, else set it 
       to TCPLOCALIP, else set it to unknown */
    /* Read the remote ip given by TCP server */
    if (config_read_string
        (QMAIL_ENV_KEY_TCPLOCALHOST, &tcplocaliptmp, defunknown)) {
        return -1;
    }

    if (config_read_string
        (QMAIL_ENV_KEY_TCPLOCALIP, &config_qmail.tcplocalip, tcplocaliptmp)) {
        return -1;
    }
    LM_STRING_FREE(tcplocaliptmp);

    /* Read tcp remote hostname given by TCP server */
    if (config_read_string
        (QMAIL_ENV_KEY_TCPREMOTEHOST, &config_qmail.tcpremotehost, defunknown)) {
        return -1;
    }

    /* Read tcp remote host info given by TCP server */
    if (config_read_string
        (QMAIL_ENV_KEY_TCPREMOTEINFO, &config_qmail.tcpremoteinfo, emptystring)) {
        return -1;
    }

    /* Read relay client info given by TCP server */
    /* This has to be handled specially since we need to know if it
       was set or not */
    if (getenv(QMAIL_ENV_KEY_RELAYCLIENT) != NULL) {
        if (config_read_string
            (QMAIL_ENV_KEY_RELAYCLIENT, &config_qmail.tcprelayclient,
             emptystring)) {
            return -1;
        }
    } else {
        config_qmail.tcprelayclient = NULL;
    }

    /* Close the env config */
    LM_CONFIG_CLOSE;

    /* Free up remaining memory */
    LM_STRING_FREE(defunknown);
    return config_qmail_verify(config_qmail);
}
