/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: config_msd.h,v 1.23 2003/10/23 23:18:32 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/*
  This file should be included by all modules which need to know
  about the program state or configuration data.
*/

#include <liblm.h>

#ifndef _CONFIG_MSD_H
#define _CONFIG_MSD_H

#define MSD_LOG_SYS "msd"

/* Compatibility type constants */
#define MSD_COMPAT_QMAIL  0
#define MSD_COMPAT_VPOP   1
#define MSD_COMPAT_MAGIC  2
#define MSD_COMPAT_DBFILE 3

typedef struct
{
  /* Constructed variables */
  lm_config_string_t helohost;
  lm_config_bool_t fakehelohost;

  lm_config_number_t loglevel;
  lm_config_number_t auth_enable;
  lm_config_string_t ext_check_passwd_prog;
  lm_config_string_t controldir;
  lm_config_number_t maxlinelen;
  lm_config_number_t maxhops;
  lm_config_number_t maxrcpt;
  lm_config_number_t rcptdelayat;
  lm_config_number_t rcptdelayinc;
  lm_config_number_t rcptdelaymax;
  lm_config_number_t check_valid_users;
  lm_config_number_t per_user_spam_enable;
  lm_config_number_t spam_log_db;

  lm_config_string_t dbname;
  lm_config_string_t dbhost;
  lm_config_string_t dbport;
  lm_config_string_t dbuser;
  lm_config_string_t dbpwd;
  lm_config_string_t conftable;
  lm_config_string_t spamtable;

  lm_config_number_t compat_type;
  lm_config_string_t qmailcontroldir;
  lm_config_string_t qmailqueue;

  lm_config_number_t max_smtp_cmds;
  lm_config_number_t max_invalid_rcpt;
  lm_config_number_t stray_newline_detection;

  lm_config_number_t add_check_flags;
  lm_config_string_t check_flag_sep;
  
  lm_config_number_t rfc_addr_only;

} config_msd_t;

int config_msd_load(int argc, char **argv);
int config_msd_cleanup(void);

/* extern config_msd_t config; */

#endif /*  _CONFIG_MSD */
