/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2000-2001 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author: Burton Samograd (burton@wizard.ca)
 * CVS Id: $Id: config_misc_rule.h,v 1.4 2003/10/23 00:03:52 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#ifndef _CONFIG_MISC_RULE_H
#define _CONFIG_MISC_RULE_H

#define NODEPS 1  
  /* Macro to clean this code up a bit and make it readable */
  /* Load a list, first checking if the use global control file is present 
   * for the list, then load the list and then append the global list
   */
#define  LOAD_LIST(_TYPE_,_DEPS_,_NAME_,_LIST_) \
if(_DEPS_) \
{ \
lm_string_t tmpstring = NULL; \
retval |= (config_read_string(_TYPE_##_CONTROL_##_NAME_, \
		&tmpstring, emptystring) != 0); \
retval |= (config_read_bool(_TYPE_##_CONTROL_USE_GLOBAL_##_NAME_, \
		&rules->use_global_##_LIST_, 1) != 0); \
if(rules->_LIST_) STRLIST_FREE(rules->_LIST_); \
retval |= STRLIST_NEW(rules->_LIST_, tmpstring); \
LM_STRING_FREE(tmpstring); \
}

#define LOAD_BOOL(_TYPE_,_DEPS_, _NAME_, _BOOL_) \
syslog(LOG_DEBUG, "XXX TRYING TO LOAD %s", #_NAME_); \
if(_DEPS_) \
    retval |= config_read_bool(_TYPE_##_CONTROL_##_NAME_, \
			   &(rules->_BOOL_), rules->_BOOL_); \

#define LOAD_STRING(_TYPE_,_DEPS_, _NAME_, _STR_) \
if(_DEPS_)\
retval |= config_read_string(_TYPE_##_CONTROL_##_NAME_, \
			   &(rules->_STR_), rules->_STR_);

#endif
