/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: config_keys.h,v 1.23 2003/10/23 23:18:32 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/*
  Environment variable names and control file keys that msd uses
*/

#ifndef _CONFIG_KEY_H
#define _CONFIG_KEY_H

/* Debug message and log level: see lmlogger.h for exact values LM_LOG_LEVEL_*
   0 no message
   1 errors
   2 warnings
   3 all
*/
/* Environment variables which can be set to control program 
   behaviour.  See the INSTALL file to see what they do.
*/
#define MSD_ENV_LOG_LEVEL "MSD_LOG_LEVEL"
#define MSD_ENV_AUTH_ENABLE "MSD_AUTH_ENABLE"
#define MSD_ENV_DEFAULT_DOMAIN "MSD_DEFAULT_DOMAIN"
#define MSD_ENV_CONTROL_DIR "MSD_CONTROLDIR"
#define MSD_ENV_QMAIL_CONTROL_DIR "MSD_QMAILCONTROLDIR"
#define MSD_ENV_QMAIL_QUEUE "MSD_QMAIL_QUEUE"
#define MSD_ENV_LOG_DIR "MSD_LOGDIR"
#define MSD_ENV_LOG_FILE "MSD_LOGFILE"
#define MSD_ENV_MAX_LINE_LENGTH "MSD_MAX_LINE_LENGTH"
#define MSD_ENV_MAX_RCPT "MSD_MAX_RCPT"
#define MSD_ENV_RCPT_DELAY_AT "MSD_RCPT_DELAY_AT"
#define MSD_ENV_RCPT_DELAY_INC "MSD_RCPT_DELAY_INC"
#define MSD_ENV_RCPT_DELAY_MAX "MSD_RCPT_DELAY_MAX"
#define MSD_ENV_MAX_HOPS "MSD_MAX_HOPS"
#define MSD_ENV_VDOMAIN_CHECKUSER_PROG "MSD_VDOMAIN_CHECKUSER_PROG"
#define MSD_ENV_EXT_CHECK_PASSWD_PROG "MSD_EXT_CHECK_PASSWD_PROG"
#define MSD_ENV_CHECK_VALID_USERS "MSD_CHECK_VALID_USERS"
#define MSD_ENV_PER_USER_SPAM_ENABLE "MSD_PER_USER_SPAM_ENABLE"
#ifdef USE_LM_DATABASE
#define MSD_ENV_DBNAME "MSD_DBNAME"
#define MSD_ENV_DBHOST "MSD_DBHOST"
#define MSD_ENV_DBPORT "MSD_DBPORT"
#define MSD_ENV_DBUSER "MSD_DBUSER"
#define MSD_ENV_DBPWD "MSD_DBPWD"
#define MSD_ENV_SPAM_TABLE "MSD_SPAM_TABLE"
#define MSD_ENV_VIRUS_TABLE "MSD_VIRUS_TABLE"
#endif 
#define MSD_ENV_COMPAT_TYPE "MSD_COMPAT_TYPE"
#define MSD_ENV_MAX_SMTP_CMDS "MSD_MAX_SMTP_CMDS"
#define MSD_ENV_MAX_INVALID_RCPT "MSD_MAX_INVALID_RCPT"
#define MSD_ENV_STRAY_NEWLINE_DETECTION "MSD_STRAY_NEWLINE_DETECTION"
#define MSD_ENV_ADD_CHECK_FLAGS "MSD_ENV_ADD_CHECK_FLAGS"
#define MSD_ENV_CHECK_FLAG_SEP "MSD_ENV_CHECK_FLAG_SEP"
#define MSD_ENV_SPAM_LOG_DB "MSD_ENV_SPAM_LOG_DB"

/* Accept only addresses in RFC2821 compliant format only:
   Name <user@host> */
#define MSD_ENV_RFC_ADDR_ONLY "MSD_RFC_ADDR_ONLY"

/* Control file names, same as above but lowercase and 
   the MSD_ prefix.
*/
#define MSD_CONTROL_LOG_LEVEL "log_level"
#define MSD_CONTROL_AUTH_ENABLE "auth_enable"
#define MSD_CONTROL_EXT_CHECK_PASSWD_PROG "ext_check_passwd_prog"
#define MSD_CONTROL_DEFAULT_DOMAIN "default_domain"
#define MSD_CONTROL_CONTROL_DIR "controldir"
#define MSD_CONTROL_QMAIL_CONTROL_DIR "qmailcontroldir"
#define MSD_CONTROL_QMAIL_QUEUE "qmail_queue"
#define MSD_CONTROL_LOG_DIR "logdir"
#define MSD_CONTROL_LOG_FILE "logfile"
#define MSD_CONTROL_MAX_LINE_LENGTH "max_line_length"
#define MSD_CONTROL_MAX_RCPT "max_rcpt"
#define MSD_CONTROL_RCPT_DELAY_AT "rcpt_delay_at"
#define MSD_CONTROL_RCPT_DELAY_INC "rcpt_delay_inc"
#define MSD_CONTROL_RCPT_DELAY_MAX "rcpt_delay_max"
#define MSD_CONTROL_MAX_HOPS "max_hops"
#define MSD_CONTROL_CHECK_VALID_USERS "check_valid_users"
#define MSD_CONTROL_PER_USER_SPAM_ENABLE "per_user_spam_enable"
#ifdef USE_LM_DATABASE
#define MSD_CONTROL_DBNAME "dbname"
#define MSD_CONTROL_DBHOST "dbhost"
#define MSD_CONTROL_DBPORT "dbport"
#define MSD_CONTROL_DBUSER "dbuser"
#define MSD_CONTROL_DBPWD "dbpwd"
#define MSD_CONTROL_SPAM_TABLE "spam_table"
#endif
#define MSD_CONTROL_COMPAT_TYPE "compat_type"
#define MSD_CONTROL_MAX_SMTP_CMDS "max_smtp_cmds"
#define MSD_CONTROL_MAX_INVALID_RCPT "max_invalid_rcpt"
#define MSD_CONTROL_STRAY_NEWLINE_DETECTION "stray_newline_detection"
#define MSD_CONTROL_RFC_ADDR_ONLY "rfc_addr_only"

#define MSD_CONTROL_ADD_CHECK_FLAGS "add_check_flags"
#define MSD_CONTROL_CHECK_FLAG_SEP "check_flag_sep"

#define MSD_CONTROL_QMAIL_LOCAL "qmail_local"
#define MSD_CONTROL_VIRUS_LOCAL "virus_local"
#define MSD_CONTROL_ALWAYS_VIRUS_CHECK "always_virus_check"
#define MSD_CONTROL_SPAM_LOG_DB "spam_log_db"

#endif
