/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author: Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: config_defaults.h,v 1.17 2003/10/17 22:05:08 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#ifndef _CONFIG_DEFAULTS_H
#define _CONFIG_DEFAULTS_H

#define MSD_CONTROL_DIR_DEFAULT "/etc/magic-mail/control/" /* Remember to put trailing /  */
#define MSD_QMAIL_CONTROL_DIR_DEFAULT "/var/qmail/control/" /* Remember to put trailing /  */
#define MSD_QMAIL_QUEUE_DEFAULT "/var/qmail/bin/qmail-queue"
#define MSD_CHECK_VDOMAIN_PROG_DEFAULT "/bin/true"
#define MSD_EXT_CHECK_PASSWD_PROG_DEFAULT "/bin/false"
#define MSD_LOG_LEVEL_DEFAULT LOG_NOTICE

#define MSD_MAX_LINE_LENGTH_DEFAULT 1024
#define MSD_MAX_SMTP_CMD_LENGTH_DEFAULT MSD_MAX_LINE_LENGTH

#define MSD_MAX_RCPT_DEFAULT (LONG_MAX-1)
#define MSD_RCPT_DELAY_AT_DEFAULT 10
#define MSD_RCPT_DELAY_INC_DEFAULT 1
#define MSD_RCPT_DELAY_MAX_DEFAULT 10

#define MSD_MAX_HOPS_DEFAULT 100

#define MSD_CHECK_VALID_USERS_DEFAULT 1
#define MSD_PER_USER_SPAM_ENABLE_DEFAULT 1

#define MSD_AUTH_ENABLE_DEFAULT 1

/* Database authentication parameters */
#define MSD_CONFIG_DBNAME_DEFAULT "dbname"
#define MSD_CONFIG_DBHOST_DEFAULT "dbserver"
#define MSD_CONFIG_DBPORT_DEFAULT "1000"
#define MSD_CONFIG_DBUSER_DEFAULT "dbuser"
#define MSD_CONFIG_DBPWD_DEFAULT "password"
#define MSD_CONFIG_CONF_TABLE_DEFAULT "config"
#define MSD_CONFIG_SPAM_TABLE_DEFAULT "spam_rules"

#define MSD_RFC_ADDR_ONLY_DEFAULT 0

/* Default constants for application */
#define MSD_MAX_SMTP_CMDS_DEFAULT (LONG_MAX-1)

#define MSD_MAX_INVALID_RCPT_DEFAULT (LONG_MAX-1)

#define MSD_STRAY_NEWLINE_DETECTION_DEFAULT (1)

#define MSD_COMPAT_TYPE_DEFAULT MSD_COMPAT_QMAIL

#define MSD_ADD_CHECK_FLAGS_DEFAULT (0)
#define MSD_CHECK_FLAG_SEP_DEFAULT "-%-"

#endif
