/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: config_common.c,v 1.4 2003/10/29 00:44:12 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#include <liblm.h>

/* Program globals */
int config_read_string(char *charkey, lm_config_string_t * string,
                       lm_config_string_t defstring)
{
    int retval;
    lm_config_key_t key = NULL;
    lm_config_string_t retstring = NULL;

    LM_STRING_NEW(key, charkey);
    retval = LM_CONFIG_READ_STRING(key, retstring, defstring);
    LM_STRING_FREE(key);

    if (*string != NULL) {
        /* syslog(LOG_ERR, "config_read_string([%s]): [%s]", charkey, LM_STRING_BUFFER(retstring)); */
        LM_STRING_FREE(*string);
    } else {
        /* syslog(LOG_ERR, "config_read_string([%s]): NOTHING", charkey); */
    }
    *string = retstring;
    return retval;
}

int config_read_number(char *charkey, lm_config_number_t * number,
                       lm_config_number_t defnumber)
{
    int retval;
    lm_config_key_t key = NULL;
    lm_config_number_t retnumber;

    LM_STRING_NEW(key, charkey);
    retval = LM_CONFIG_READ_NUMBER(key, retnumber, defnumber);
    LM_STRING_FREE(key);
    *number = retnumber;
    return retval;
}

int config_read_bool(char *charkey, lm_config_bool_t * bool,
                     lm_config_bool_t defbool)
{
    int retval;
    lm_config_key_t key = NULL;
    lm_config_bool_t retbool;

    LM_STRING_NEW(key, charkey);
    retval = LM_CONFIG_READ_BOOL(key, retbool, defbool);
    LM_STRING_FREE(key);
    *bool = retbool;
    return retval;
}
