/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * Copyright (c) 2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Josh Wilsdon <josh@wizard.ca>
 *
 * Version: $Id: spam_log.c,v 1.3 2003/10/29 17:56:55 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 *
 */

/* stanadard libraries */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <syslog.h>
#define _GNU_SOURCE             /* do this so we can use strdup() */
#include <string.h>

/* local libraries */
#include "spam_log.h"

/* global spam log structure */
spam_log_t spam_log;

/* 
 * SUMMARY: 
 *
 * This function initializes the spam_log structure.
 *
 * RETURN VALUE:
 * 
 *  none
 *
 */
void initSpamLog(char *rcptuser, char *rcptdomain, char *sender)
{

    spam_log.entries = 0;
    spam_log.domain = strdup(rcptdomain);
    spam_log.user = strdup(rcptuser);
    spam_log.sender = strdup(sender);
    spam_log.first = NULL;
    spam_log.last = NULL;
    spam_log.subject = NULL;

    return;
}

int addSpamLog(char *rule, char *info, int score, int global)
{
    spam_log_entry_t *new;

    syslog(LOG_DEBUG, "addSpamLog(%s,%s,%d,%d)\n", rule, info, score, global);

    if (rule == NULL) {
        /* invalid input */
        return (2);
    }

    new = malloc(sizeof(spam_log_entry_t));
    /* TODO: free this later */

    if (new == NULL) {
        syslog(LOG_ERR, "addSpamLog(): out of memory\n");
        return (1);
    }

    /* start with a fresh entry */
    bzero(new, sizeof(spam_log_entry_t));

    /* attempt to duplicate the values */
    new->rule = strdup(rule);

    /* info is allowed to be NULL if the rule has no additional info */
    if (info != NULL) {
        new->info = strdup(info);
    } else {
        new->info = NULL;
    }

    /* TODO: free (new->rule + new->info) later */
    new->score = score;
    new->global = global;

    if (new->rule == NULL) {
        syslog(LOG_ERR, "addSpamLog(): out of memory\n");
        return (1);
    }

    if (spam_log.first == NULL) {
        /* this is first (thereby only) rule */

        spam_log.first = spam_log.last = new;

    } else {
        /* this is additional rule */

        spam_log.last->next = new;
        spam_log.last = new;

    }

    /* added an entry */
    spam_log.entries++;

    return (0);
}
