#!/usr/bin/perl -w
#
# COPYRIGHT INFORMATION - DO NOT REMOVE
# "Portions Copyright (c) 2003 LinuxMagic Inc. All Rights Reserved.
#
# This file contains Original Code and/or Modifications of Original Code as
# defined in and that are subject to the Free Source Code License Version
# 1.0 (the 'License'). You may not use this file except in compliance with
# the License. Please obtain a copy of the License at:
#
# http://www.linuxmagic.com/opensource/licensing/FSCL.txt
#
# and read it before using this file.
#
# The Original Code and all software distributed under the License are
# distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
# the License for the specific language governing rights and limitations
# under the License."
#
# Please read the terms of this license carefully. By using or downloading
# this software or file, you are accepting and agreeing to the terms of this
# license with LinuxMagic Inc. If you are agreeing to this license on behalf
# of a company, you represent that you are authorized to bind the company to
# such a license. If you do not meet this criterion or you do not agree to
# any of the terms of this license, do NOT download, distribute, use or alter
# this software or file in any way.
#
# Author(s): Josh Wilsdon <josh@wizard.ca>
#
# CVS Id: $Id: parse_spam_rules.pl,v 1.3 2003/09/23 00:19:40 josh Exp $
#
# DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
#


use strict;

### CONFIG
my $spam_rules_file = 'spam_rules';

### END CONFIG

my ($line, $lineno, $name, $type, $points, $counter);
my @rule_data;
my @rule_names;

open (RULES_H, "< $spam_rules_file") || die "could not open $spam_rules_file";
$lineno=0;
while ($line = <RULES_H>) {
    $lineno++;
    if (($line =~ m/^[^#]/) && ($line !~ m/^\s+$/)) {
        chomp($line);
        $line =~ s/\s+/\ /g;
        ($name, $type, $points) = split(' ', $line);
        if ((defined $name) && (defined $type) && (defined $points)) {
            if ($name !~ m/^[a-z\_]+$/) {
                die "$spam_rules_file\: BAD NAME on line $lineno.";
            }
            if ($type !~ m/^(boolean|integer|string)$/) {
                die "$spam_rules_file\: BAD TYPE on line $lineno.";
            }
    
            # translate type into one of supported types
            if ($type eq "boolean") {
                $type = "RULE_BOOL";
            } elsif ($type eq "integer") {
                $type = "RULE_INT";
            } elsif ($type eq "string") {
                $type = "RULE_STRING";
            }

            if ($points !~ m/^\-?[0-9]+$/) {
                die "$spam_rules_file\: BAD POINT VALUE on line $lineno.";
            }
            push (@rule_names, ("SPAM_RULE_" . uc($name)));
            push (@rule_data, "{ \"$name\", 0, $type, $points, NULL, NULL },");
        }
    }
}

close(RULES_H);

push (@rule_data, "{ NULL, 0, 0, 0, NULL, NULL }");

print "\n/*\n";
print " * THIS FILE WAS AUTOGENERATED. DO NOT EDIT!!  YOUR CHANGES WILL BE LOST!!\n";  
print " * Edit spam_rules instead.\n";
print " *\n";
print " */\n";

$counter = 0;
while (@rule_names) {
    print "#define " . shift(@rule_names) . " $counter\n";
    $counter++;
}

print "\n";

print "#define SPAM_RULES { \\\n";
while (@rule_data) {
    print shift(@rule_data) . " \\\n";
}
print "}\n";
