#!/usr/bin/perl -w
#
# COPYRIGHT INFORMATION - DO NOT REMOVE
# "Portions Copyright (c) 2003 LinuxMagic Inc. All Rights Reserved.
#
# This file contains Original Code and/or Modifications of Original Code as
# defined in and that are subject to the Free Source Code License Version
# 1.0 (the 'License'). You may not use this file except in compliance with
# the License. Please obtain a copy of the License at:
#
# http://www.linuxmagic.com/opensource/licensing/FSCL.txt
#
# and read it before using this file.
#
# The Original Code and all software distributed under the License are
# distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
# the License for the specific language governing rights and limitations
# under the License."
#
# Please read the terms of this license carefully. By using or downloading
# this software or file, you are accepting and agreeing to the terms of this
# license with LinuxMagic Inc. If you are agreeing to this license on behalf
# of a company, you represent that you are authorized to bind the company to
# such a license. If you do not meet this criterion or you do not agree to
# any of the terms of this license, do NOT download, distribute, use or alter
# this software or file in any way.
#
# Author(s): Josh Wilsdon <josh@wizard.ca>
#
# CVS Id: $Id: parse_control_files.pl,v 1.1 2003/09/23 00:19:40 josh Exp $
#
# DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
#


use strict;

### CONFIG
my $control_files_file = 'control_files';

### END CONFIG

my ($line, $lineno, $name, $type, $type_code, $default, $counter);
my @file_data;
my @type_data;

open (FILES_H, "< $control_files_file") || die "could not open $control_files_file";
$lineno=0;
while ($line = <FILES_H>) {
    $lineno++;
    if (($line =~ m/^[^#]/) && ($line !~ m/^\s+$/)) {
        chomp($line);
        $line =~ s/\s+/\ /g;
        ($name, $type, $default) = split(' ', $line);
        if ((defined $name) && (defined $type)) {
            if (!defined $default) {
                $default = "";
            }
            if ($name !~ m/^[a-z\-\_]+$/) {
                die "$control_files_file\: BAD NAME on line $lineno.";
            }
            if ($type !~ m/^(boolean|integer|string|directory|filename|program)$/) {
                die "$control_files_file\: BAD TYPE on line $lineno.";
            }
    
            # translate type into one of supported types
            if ($type eq "boolean") {
                $type = "int";
                $type_code = "CONTROL_BOOL";
            } elsif ($type eq "integer") {
                $type = "int";
                $type_code = "CONTROL_INT";
            } elsif ($type eq "string") {
                $type = "char *";
                $type_code = "CONTROL_STRING";
            } elsif ($type eq "directory") {
                $type = "char *";
                $type_code = "CONTROL_DIR";
            } elsif ($type eq "filename") {
                $type = "char *";
                $type_code = "CONTROL_FILE";
            } elsif ($type eq "program") {
                $type = "char *";
                $type_code = "CONTROL_PROG";
            }

            if (length($default) == 0) {
                $default = "NULL";
            } else {
                $default = "\"$default\"";
            }

            push (@file_data, "$type $name;");
            push (@type_data, "{ \"$name\", offsetof(config_t, $name), $type_code, $default },");
        }
    }
}

push (@type_data, "{ NULL, 0, 0, NULL }");

close(FILES_H);

print "\n/*\n";
print " * THIS FILE WAS AUTOGENERATED. DO NOT EDIT!!  YOUR CHANGES WILL BE LOST!!\n";  
print " * Edit config_files instead.\n";
print " *\n";
print " */\n";

print "typedef struct { \n";
while (@file_data) {
    print "    " . shift(@file_data) . "\n";
}
print "} config_t;\n\n";

print "#define CONFIG_TYPE_DATA { \\\n";
while (@type_data) {
    print shift(@type_data) . "\\\n";
}
print "};\n";


