/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2000-2001 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author: Burton Samograd (burton@wizard.ca)
 * CVS Id: $Id: main.c,v 1.3 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <crypt.h>

#include "../libgetbdb.h"
#include "spam_rules.h"
#include "load_rules.h"

spam_rule_t user_rules[] = SPAM_RULES;
spam_rule_t global_rules[] = SPAM_RULES;

int load_user_spam_rules(char *user);

int load_user_spam_rules(char *user)
{
    DB *dbp;
    unsigned int len;
    char *realuser, *tmpuser, *data, *email_id = NULL, *ptr, *key, *value;
    int ret;

    if (user == NULL) {
        return (-1);
    }

    dbp = openDBFile(USER_DBFILE);
    if (dbp == NULL) {
        return (-1);
    }

    /* TODO: append default domain if needed */

    printf("CHECKING SPAM FOR [%s]\n", user);
    fflush(stdout);
    tmpuser = strdup(user);
    if (tmpuser == NULL) {
        return (-1);
    }
    ret = getRealUser(dbp, tmpuser, &data);
    free(tmpuser);
    if (ret == 0) {
        realuser = strdup(data);
        printf("CHECKING SPAM FOR realuser [%s]\n", realuser);
        fflush(stdout);
        if (realuser == NULL) {
            return (-1);
        }
        ret = getSpamEmailID(dbp, realuser, &len, &data);
        free(realuser);
        email_id = strdup(data);
    }
    closeDBFile(dbp);

    printf("CLOSED DBFILE\n");
    fflush(stdout);

    if (email_id != NULL) {
        printf("EMAIL_ID: [%s]\n", email_id);
        fflush(stdout);
        dbp = openDBFile(SPAM_DBFILE);

        ret = getSpamRules(dbp, email_id, &len, &data);
        free(email_id);

        /* spam rules are in data */

        ptr = data;
        while ((ptr - data) < len) {
            key = ptr;
            ptr += strlen(key) + 1;
            if ((ptr - data) < len) {
                value = ptr;
                ptr += strlen(value) + 1;
                setSpamRule(1, key, value);
                printf("RULE[%s] = [%s]\n", key, value);
                fflush(stdout);
            } else {
                printf("FATAL: Corrupted spam rules\n");
                fflush(stdout);
                break;
            }
        }

        closeDBFile(dbp);

        //return (0);
    } else {
        printf("DID NOT FIND EMAIL_ID\n");
        fflush(stdout);
    }

    return (1);
}

int main()
{
    char user[] = "michael@wizard.ca";

    load_user_spam_rules(user);
    printSpamRules();
    exit(0);
}
