/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * Copyright (c) 2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Josh Wilsdon <josh@wizard.ca>
 *
 * Version: $Id: load_rules.c,v 1.2 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 *
 */

/* stanadard libraries */
#include <sys/types.h>
#include <regex.h>
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <unistd.h>
#define _GNU_SOURCE             /* do this so we can use strdup() */
#include <string.h>

/* local libraries */
#include "load_rules.h"
#include "spam_rules.h"

/* local functions */
static int addValue(spam_rule_t * rules, char *value);

/* global + user spam rule structures */
extern spam_rule_t user_rules[];
extern spam_rule_t global_rules[];

void printSpamRules(void)
{
    spam_rule_t *ptr;
    spam_rule_entry_t *value;

    /* printf("----user----\n"); */
    ptr = user_rules;
    while (ptr->key != NULL) {
        if (ptr->entries > 0) {
            printf("user: [%s] (%d): ", ptr->key, ptr->entries);
            value = ptr->first;
            while ((value != NULL) && (value->data != NULL)) {
                printf("[%s]", (char *) value->data);
                value = value->next;
            }
            printf("\n");
        }
        ptr++;
    }
    /* printf("---global---\n"); */
    ptr = global_rules;
    while (ptr->key != NULL) {
        if (ptr->entries > 0) {
            printf("global: [%s] (%d): ", ptr->key, ptr->entries);
            value = ptr->first;
            while ((value != NULL) && (value->data != NULL)) {
                printf("[%s]", (char *) value->data);
                value = value->next;
            }
            printf("\n");
        }
        ptr++;
    }
}

int addValue(spam_rule_t * rules, char *value)
{
    spam_rule_entry_t *new;

    new = malloc(sizeof(spam_rule_entry_t));
    /* TODO: free this later */

    if (new == NULL) {
        syslog(LOG_ERR, "addValue(): out of memory\n");
        exit(111);
    }

    /* start with a fresh entry */
    bzero(new, sizeof(spam_rule_entry_t));

    /* attempt to duplicate the value */
    new->data = strdup(value);
    /* TODO: free this later */

    if (new->data == NULL) {
        syslog(LOG_ERR, "addValue(): out of memory\n");
        exit(111);
    }

    if (rules->first == NULL) {
        /* this is first (thereby only) rule */

        rules->first = rules->last = new;

    } else {
        /* this is additional rule */

        rules->last->next = new;
        rules->last = new;

    }

    /* added an entry */
    rules->entries++;

    return (0);
}

int setSpamRule(int id, char *key, char *value)
{
    spam_rule_t *rules;

    if (id == 0) {
        /* this is a global rule */
        rules = global_rules;
    } else {
        /* this is a user rule */
        rules = user_rules;
    }

    while (rules->key != NULL) {
        /* TODO: strncmp() */
        /* printf("key[%s][%s]\n", ptr->key, key); */
        if (strcmp(rules->key, key) == 0) {
            /* match */
            addValue(rules, value);
        }
        rules++;
    }

    return (0);
}
