/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * Copyright (c) 2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Josh Wilsdon <josh@wizard.ca>
 *
 * Version: $Id: clean_rules.c,v 1.3 2003/09/19 18:56:03 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 *
 */

/* stanadard libraries */
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <unistd.h>
#define _GNU_SOURCE             /* do this so we can use strdup() */
#include <string.h>

/* local libraries */
#include "spam_rules.h"

void cleanRules(spam_rule_t * rules);

/* local functions */
static void freeRuleEntries(spam_rule_entry_t * entry);

/* 
 * free all entries recursively from entry down the chain
 * 
 */
void freeRuleEntries(spam_rule_entry_t * entry)
{
    if (entry == NULL) {
        return;
    } else {
        if (entry->data != NULL) {
            free(entry->data);
        }
        freeRuleEntries(entry->next);
        free(entry);
    }
    return;
}

/* 
 *  This function cleans out the user data from the spam_rule_t structure
 *  pointed to by "rules".  It will zero the entries counter, and free all
 *  entries attached to each rule.
 *
 */
void cleanRules(spam_rule_t * rules)
{

    while (rules->key != NULL) {
        if (rules->entries > 0) {

            // printf("CLEANING %d ENTRIES FROM [%s]\n", rules->entries, rules->key);

            /* free the entries attached to this rule */
            freeRuleEntries(rules->first);

            /* finally zero the entries counter, and pointers, since we free()'d all entries */
            rules->entries = 0;
            rules->first = NULL;
            rules->last = NULL;
        }
        rules++;
    }

    return;
}
