/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: cdb.c,v 1.8 2003/09/19 18:56:02 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/* C includes */
#include <stdio.h>
#include <string.h>

/* lmlib includes */
#include <liblm.h>
#include "cdb.h"

/* Module constants */
#define CDB_SALT ((unsigned long)5381)

/* See if the given key and the current cdb record match */
static int cdb_match(char *key, int keylen, char *buffer)
{
    int i;

    for (i = 0; i < keylen; i++) {
        if (key[i] != buffer[i]) {
            return 1;
        }
    }
    return 0;
}

/* Calculate the cdb hash for the given key */
static unsigned int cdb_hash(char *key, int len)
{
    unsigned int hash = CDB_SALT;

    while (len != 0) {
        --len;
        hash += (hash << 5);
        hash ^= (unsigned int) *key++;
    }
    return hash;
}

int cdb_users_lookup(FILE * file, char *key, int keylen, cdb_users_rec_t * rec)
{
    char buffer[1024];

    /* Look up the record in the cdb file and read it into the buffer */
    if (cdb_lookup2(file, key, keylen, buffer, sizeof(buffer))) {
        return -1;
    }

    /* TODO Parse the returned record and fill in the cdb_user_rect structure */

    return 0;
}

/* TODO Get rid of cdb_lookup and convert code to use cdb_users_lookup */
int cdb_lookup2(FILE * file, char *key, int keylen, char *buffer, int bufferlen)
{
    unsigned int hash;
    unsigned int readhash;
    int first, second;
    int pos, len;
    int recpos, reclen;
    int hashpos;
    int offset, offset2;

    if (file == NULL) {
        return -1;
    }

    hash = cdb_hash(key, keylen);

    offset = hash & 255;
    offset *= 8;

    fseek(file, offset, SEEK_SET);
    fread(&first, sizeof(first), 1, file);
    fread(&second, sizeof(second), 1, file);

    /* Pos is the offset of the second hash table in the file
     * len is the length of the hash table, which is a power of 2 
     */
    pos = first;
    len = second;

    /* If len is zero, the entry wasn't in the table? */
    if (len == 0) {
        /* Entry not in cdb file */
        return 1;
    }

    /* Top part of hash contains offset into second table */
    offset = (hash >> 8) % len;

    /* Go to the offset found in the last read, and then perform a 
     * linear search until we find the matching record 
     */
    for (hashpos = 0; hashpos < len; hashpos++) {

        /* Read the second level entry in the hash table */
        offset2 = pos + offset * 8;
        fseek(file, offset2, SEEK_SET);
        fread(&first, sizeof(first), 1, file);
        fread(&second, sizeof(second), 1, file);

        readhash = first;
        recpos = second;
        if (recpos == 0) {
            /* Return error of some sort */
            /*("Record position is equal to zero!") */
            return -1;
        }

        if (readhash == hash) {

            unsigned int numchars;

            fseek(file, recpos, SEEK_SET);
            fread(&first, sizeof(first), 1, file);
            fread(&second, sizeof(second), 1, file);

            numchars = first;
            reclen = second + keylen;

            if (keylen == numchars) {
                int bytesread;

                if (reclen > bufferlen) {
                    return -1;
                }
                memset(buffer, 0, bufferlen);
                bytesread = fread(buffer, 1, reclen, file);
                if (bytesread != reclen) {
                    return -1;
                }

                if (!cdb_match(key, keylen, buffer)) {
                    return 0;
                }
            }
        }

        offset++;
        if (offset == len) {
            offset = 0;
        }
    }

    return 1;
}

/* Attempt to find the record specified by key in a cdb file */
/* Returns the user's home directory if it is found */
int cdb_lookup(FILE * file, char *key, int keylen, lm_string_t * phomedir)
{
    unsigned int hash;
    unsigned int readhash;
    int first, second;
    char buffer[1024];
    int pos, len;
    int recpos, reclen;
    int hashpos;
    int offset, offset2;
    lm_string_t tmphomedir = NULL;

    if (file == NULL) {
        return -1;
    }

    hash = cdb_hash(key, keylen);

    offset = hash & 255;
    offset *= 8;

    fseek(file, offset, SEEK_SET);
    fread(&first, sizeof(first), 1, file);
    fread(&second, sizeof(second), 1, file);

    /* Pos is the offset of the second hash table in the file
     * len is the length of the hash table, which is a power of 2 
     */
    pos = first;
    len = second;

    /* If len is zero, the entry wasn't in the table? */
    if (len == 0) {
        /* Entry not in cdb file */
        return 1;
    }

    /* Top part of hash contains offset into second table */
    offset = (hash >> 8) % len;

    /* Go to the offset found in the last read, and then perform a 
     * linear search until we find the matching record 
     */
    for (hashpos = 0; hashpos < len; hashpos++) {

        /* Read the second level entry in the hash table */
        offset2 = pos + offset * 8;
        fseek(file, offset2, SEEK_SET);
        fread(&first, sizeof(first), 1, file);
        fread(&second, sizeof(second), 1, file);

        readhash = first;
        recpos = second;
        if (recpos == 0) {
            /* Return error of some sort */
            /*("Record position is equal to zero!") */
            return -1;
        }

        if (readhash == hash) {

            unsigned int numchars;

            fseek(file, recpos, SEEK_SET);
            fread(&first, sizeof(first), 1, file);
            fread(&second, sizeof(second), 1, file);

            numchars = first;
            reclen = second + keylen;

            if (keylen == numchars) {
                int i, bytesread;

                if (reclen > sizeof(buffer)) {
                    return -1;
                }
                memset(buffer, 0, sizeof(buffer));
                bytesread = fread(buffer, 1, reclen, file);
                if (bytesread != reclen) {
                    return -1;
                }

                if (!cdb_match(key, keylen, buffer)) {
                    int count = 0;

                    i = keylen;
                    while (i < reclen && count < 3) {
                        if (!buffer[i]) {
                            count++;
                        }
                        i++;
                    }

                    LM_STRING_NEW(tmphomedir, &buffer[i]);
                    LM_ASSERT(*phomedir == NULL);
                    *phomedir = tmphomedir;

                    return 0;
                }
            }
        }

        offset++;
        if (offset == len) {
            offset = 0;
        }
    }

    return 1;
}
