/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/FSCL.txt
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *
 * CVS Id: $Id: b64.c,v 1.5 2003/09/19 18:56:02 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

#include <liblm.h>
#include <string.h>

static char *b64alpha =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
#define B64PAD '='

int b64decode(lm_string_t instr, lm_string_t * poutstr)
{
    unsigned char *in = NULL;
    char *out = NULL;
    char *s = NULL;
    lm_string_t outstr = NULL;
    int inlen;
    int outlen;
    int i, j;
    unsigned char a[4];
    unsigned char b[3];

    in = LM_STRING_BUFFER(instr);
    inlen = LM_STRING_LEN(instr);
    outlen = inlen + 2;
    if (LM_MALLOC(out, outlen)) {
        return -1;
    }
    s = out;
    LM_ASSERT(out);

    for (i = 0; i < inlen; i += 4) {
        for (j = 0; j < 4; j++) {
            if (((i + j) < inlen) && (in[i + j] != B64PAD)) {
                char *tmp;

                tmp = strchr(b64alpha, in[i + j]);
                if (tmp == NULL) {
                    LM_FREE(out);
                    return 1;
                }
                a[j] = tmp - b64alpha;
            } else {
                a[j] = 0;
            }
        }

        b[0] = (a[0] << 2) | (a[1] >> 4);
        b[1] = (a[1] << 4) | (a[2] >> 2);
        b[2] = (a[2] << 6) | (a[3]);

        *s++ = b[0];

        if (in[i + 1] == B64PAD) {
            break;
        }
        *s++ = b[1];

        if (in[i + 2] == B64PAD) {
            break;
        }
        *s++ = b[2];
    }
    /* null terminate */
    LM_ASSERT(s != NULL);
    *s = '\0';

    LM_ASSERT(*poutstr == NULL);
    if (LM_STRING_NEW(outstr, out)) {
        return -1;
    }
    *poutstr = outstr;
    LM_FREE(out);
    return 0;
}

int b64encode(lm_string_t instr, lm_string_t * poutstr)
{
    unsigned char a, b, c;
    char *s;
    char *out = NULL;
    char outlen;
    char *in;
    int inlen;
    int i;
    lm_string_t outstr = NULL;

    in = LM_STRING_BUFFER(instr);
    inlen = LM_STRING_LEN(instr);

    if (inlen == 0) {
        if (LM_STRING_NEW(outstr, "")) {
            return -1;
        }
        *poutstr = outstr;
        return 0;
    }

    outlen = inlen / 3 * 4 + 4;
    if (LM_MALLOC(out, outlen)) {
        return -1;
    }
    LM_ASSERT(out);

    s = out;

    for (i = 0; i < inlen; i += 3) {
        a = in[i];
        b = i + 1 < inlen ? in[i + 1] : 0;
        c = i + 2 < inlen ? in[i + 2] : 0;

        *s++ = b64alpha[a >> 2];
        *s++ = b64alpha[((a & 3) << 4) | (b >> 4)];

        if (i + 1 >= inlen) {
            *s++ = B64PAD;
        } else {
            *s++ = b64alpha[((b & 15) << 2) | (c >> 6)];
        }

        if (i + 2 >= inlen) {
            *s++ = B64PAD;
        } else {
            *s++ = b64alpha[c & 63];
        }
    }

    /* null terminate */
    LM_ASSERT(s != NULL);
    *s = '\0';

    if (LM_STRING_NEW(outstr, out)) {
        return -1;
    }
    LM_FREE(out);
    *poutstr = outstr;

    return 0;
}
