/*
 * COPYRIGHT INFORMATION - DO NOT REMOVE
 * "Portions Copyright (c) 2002-2003 LinuxMagic Inc. All Rights Reserved.
 *
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the Free Source Code License Version
 * 1.0 (the 'License'). You may not use this file except in compliance with
 * the License. Please obtain a copy of the License at:
 *
 * http://www.linuxmagic.com/opensource/licensing/
 *
 * and read it before using this file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND LINUXMAGIC HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. Please see
 * the License for the specific language governing rights and limitations
 * under the License."
 *
 * Please read the terms of this license carefully. By using or downloading
 * this software or file, you are accepting and agreeing to the terms of this
 * license with LinuxMagic Inc. If you are agreeing to this license on behalf
 * of a company, you represent that you are authorized to bind the company to
 * such a license. If you do not meet this criterion or you do not agree to
 * any of the terms of this license, do NOT download, distribute, use or alter
 * this software or file in any way.
 *
 * Author(s): Burton Samograd <burton@wizard.ca>
 *            Josh Wilsdon <josh@wizard.ca>
 *
 * CVS Id: $Id: auth.c,v 1.33 2003/10/23 23:18:32 josh Exp $
 *
 * DO NOT MODIFY WITHOUT CONSULTING THE LICENSE
 */

/* C includes */
#include <liblm.h>

#include "b64.h"
#include "auth.h"
#include "smtp.h"
#include "magic-smtpd.h"
#include "config_msd.h"
#include "config_qmail.h"

#include "common/controls.h"
#include "common/load_controls.h"

extern config_t config;
extern config_type_t config_type_info[];


static int msd_do_auth_helper(int type, lm_string_t username, lm_string_t password);


int msd_do_auth(int type, lm_string_t username64)
{
    lm_string_t username = NULL;
    lm_string_t password = NULL;
    lm_string_t password64 = NULL;
    int retval = 0;

    /*
     * TODO: when we do this properly (modules) we'll need to have a function 
     *       supported_types() which will tell us which are supported.  We can
     *       then check to see if this is one of them.
     *
     */

    /* Only support LOGIN auth type for now */
    if (type != SMTP_AUTH_LOGIN) {
        syslog(LOG_INFO, "Unsupported authorization type requested (not LOGIN)");
        return LM_AUTH_UNSUPPORTED;
    }

    if (username64 == NULL) {
        /* Print the Username: prompt in base64, read an input line and decode 
         * it to get the username */
        printf("334 VXNlcm5hbWU6\r\n"); /* Username: */
        fflush(stdout);
        msd_timeout_read(0, &username64);
        LM_STRING_CHOP(username64);
        /* check for user cancel '*' */
        if (LM_STRING_LEN(username64) == 1
            && LM_STRING_BUFFER(username64)[0] == '*') {
            /* user canceled */
            LM_STRING_FREE(username64);
            return LM_AUTH_CANCEL;
        }
    }
    if (b64decode(username64, &username)) {
        LM_ASSERT(username == NULL);
        LM_STRING_FREE(username64);
        return LM_AUTH_BAD_DATA;
    } else {
        LM_STRING_CHOP(username);
    }
    LM_STRING_FREE(username64);

    /* Print the Password: prompt in base64, read an input line and decode it to
     * get the password */
    printf("334 UGFzc3dvcmQ6\r\n"); /* Password: */
    fflush(stdout);
    msd_timeout_read(0, &password64);
    LM_STRING_CHOP(password64);
    /* check for user cancel '*' */
    if (LM_STRING_LEN(password64) == 1
        && LM_STRING_BUFFER(password64)[0] == '*') {
        /* user canceled */
        LM_STRING_FREE(username);
        LM_STRING_FREE(password64);
        return LM_AUTH_CANCEL;
    }
    if (b64decode(password64, &password)) {
        /* failure to decode */
        LM_ASSERT(password == NULL);
        LM_STRING_FREE(username);
        LM_STRING_FREE(password64);
        return LM_AUTH_BAD_DATA;
    } else {
        LM_STRING_CHOP(password);
    }
    LM_STRING_FREE(password64);

    retval = msd_do_auth_helper(type, username, password);

    if (retval == LM_AUTH_OK) {
        /* set the relayclient variable and set remoteinfo to the username */
        if (config_qmail.tcprelayclient) {
            LM_STRING_FREE(config_qmail.tcprelayclient);
        }
        LM_STRING_NEW(config_qmail.tcprelayclient, "");
        LM_STRING_FREE(config_qmail.tcpremoteinfo);
        /* TODO: escape username */
        LM_STRING_NEW(config_qmail.tcpremoteinfo, LM_STRING_BUFFER(username));
        syslog(LOG_INFO, "AUTH success: [%s]", LM_STRING_BUFFER(username));
    } else {
        syslog(LOG_INFO, "AUTH failure: [%s]", LM_STRING_BUFFER(username));
    }

    LM_STRING_FREE(username);   /* don't need this anymore */
    LM_STRING_FREE(password);   /* don't need this anymore */

    return (retval);
}

int msd_do_auth_helper(int type, lm_string_t username, lm_string_t password)
{
    int ret;

#ifdef USE_LM_DATABASE
    if (config.use_database != 0) {
        syslog(LOG_DEBUG, "trying AUTH against database");
        ret = msd_do_auth_db(type, username, password);

        switch (ret) {
            case LM_AUTH_OK:
                /* FALLTHROUGH */
            case LM_AUTH_FAILED:
                return (ret);
                break;
            case LM_AUTH_NO_USER:
                /* FALLTHROUGH */
            case LM_AUTH_ERROR:
                /* FALLTHROUGH */
            case LM_AUTH_ERROR_DB:
                /* FALLTHROUGH */
            default:
                /* pass through to next method */
                break;
        }
    }
#endif

    /* external program method is always available */
    if (config.ext_check_passwd_prog != NULL) {
        syslog(LOG_DEBUG, "trying AUTH against external program");
        ret = msd_do_auth_chkp(type, username, password);

        switch (ret) {
            case LM_AUTH_OK:
                /* FALLTHROUGH */
            case LM_AUTH_FAILED:
                return (ret);
                break;
            case LM_AUTH_BAD_DATA:
                /* FALLTHROUGH */
            case LM_AUTH_ERROR:
                /* FALLTHROUGH */
            case LM_AUTH_UNSUPPORTED:
                /* FALLTHROUGH */
            default:
                /* pass through to next method */
                break;
        }
    }

#ifdef USE_LM_DBFILE
    if (config.use_dbfile != 0) {
        syslog(LOG_DEBUG, "trying AUTH against dbfile");
        ret = msd_do_auth_dbfile(type, username, password);

        switch (ret) {
            case LM_AUTH_OK:
                /* FALLTHROUGH */
            case LM_AUTH_FAILED:
                return (ret);
                break;
            case LM_AUTH_NO_USER:
                /* FALLTHROUGH */
            case LM_AUTH_ERROR:
                /* FALLTHROUGH */
            default:
                /* pass through to next method */
                break;
        }
    }
#endif

    return (LM_AUTH_ERROR);
}
